/** @file dig_inputs.c
 
   Contains all functions to read digital inputs of the APCIE-1516.
 
   @par CREATION  
   @author Krauth Julien
   @date   14.06.05
   
   @par VERSION
   @verbatim
   $LastChangedRevision:$
   $LastChangedDate:$
   @endverbatim   
   
   @par COMPILER
   @verbatim
   Compiler	: gcc
   Version	: gcc (GCC) 3.3.6 (Debian 1:3.3.6-5)   
   kernel	: 2.4.26
   @endverbatim  
   
   @par UPDATES
   @verbatim
   Date			:
   Author		: 
   Description	: 
   @endverbatim    
    
   @par LICENCE
   @verbatim
   Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
   ADDI-DATA GmbH
   Airpark Business Center
   Airport Boulevard B210
   77836 Rheinmnster
   Germany
   Tel: +49(0)7229/1847-0
   Fax: +49(0)7229/1847-200
   http://www.addi-data-com
   info@addi-data.com
        
   This program is free software; you can redistribute it and/or modify it under 
   the terms of the GNU General Public License as published by the Free Software 
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. 
   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with 
   this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   You shoud also find the complete GPL in the COPYING file 
   accompanying this source code.
   @endverbatim   
 */

#include <apcie1516-kapi.h> 
#include "apcie1516-private.h"

/**@def EXPORT_NO_SYMBOLS
 * Function in this file are not exported.
 */
EXPORT_NO_SYMBOLS;

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,27)
	#define __user 
#endif

//------------------------------------------------------------------------------

/** Read all digital inputs of the APCIE-1516.
 *
 * @param [in,out]	pdev	Pointer on the device structure.
 * @param [in]		cmd		IOCTL command. The command is <br>
 * 							CMD_APCIE1516_Read8DigitalInputs when using the IOCTL funktion.<br>
 * 							To call the function in kernel mode, cmd must be 0.
 * @param [out]		arg		Function argument. An unsigned char that will contain port state.
 *
 * @retval 0		No error. 
 * @retval -EFAULT	Can't return parameters.
 */
int do_CMD_APCIE1516_Read8DigitalInputs(struct pci_dev *pdev, unsigned int cmd, unsigned long arg)
{
	int ret;
	uint8_t PortState = 0;		/**< Port state:<br>
                                        One port is composed of 8 channels.<br>
                                        One channel can be 1 (high) or 0 (low) */

	/* no need to lock since no private data are accessed */

	/* Get the state of port 0 */
	
	if ( (ret = APCIE1516_Read8DigitalInputs(pdev, &PortState) ) )
		return ret;
	
	if ( copy_to_user((unsigned char __user *) arg, (unsigned int*)&PortState, sizeof(PortState)) )
		return -EFAULT;

	return 0;
}
