 /* @file api.h
  * 
  * @brief Mainly this header should contains definition of ioctl handler. 
  * 
  * 
  * 
  */

/** @par LICENCE
 * 
 *  @verbatim
   Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
   ADDI-DATA GmbH
   Airpark Business Center
   Airport Boulevard B210
   77836 Rheinmnster
   Germany
   Tel: +49(0)7229/1847-0
   Fax: +49(0)7229/1847-200
   http://www.addi-data-com
   info@addi-data.com
 
 This library is free software; you can redistribute it and/or modify it under 
 the terms of the GNU Lesser General Public License as published by the 
 Free Software Foundation; either version 2.1 of the License, 
 or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 or FITNESS FOR A PARTICULAR PURPOSE. 
 See the GNU Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public License 
 along with this library; if not, write to the Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 
 
 You also shoud find the complete LGPL in the LGPL.txt file accompanying 
 this source code.
 
 @endverbatim
**/

#ifndef __APCIE1516_API_H_
#define __APCIE1516_API_H_

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/* deprecated */
int do_CMD_APCIE1516_CheckAndGetPCISlotNumber(struct pci_dev * pdev,unsigned int cmd, unsigned long arg);
int do_CMD_APCIE1516_GetHardwareInformation(struct pci_dev * pdev, unsigned int cmd, unsigned long arg);

//------------------------------------------------------------------------------
int do_CMD_APCIE1516_SetBoardInformation(struct pci_dev * pdev, unsigned int cmd, unsigned long arg);

/* Digital inputs functions (dig_inputs.c) */
int do_CMD_APCIE1516_Read8DigitalInputs(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);

/* Digital outputs functions (dig_outputs.c) */
int do_CMD_APCIE1516_Set8DigitalOutputsOn(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE1516_Set8DigitalOutputsOff(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE1516_SetDigitalOutputMemoryOn(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE1516_SetDigitalOutputMemoryOff(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE1516_Get8DigitalOutputStatus(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);

/** Execute a command in user space.
*
* @param pdev Pointer to a device.
* @param cmd Command to execute
* @param arg Argument of the command.
*/
int apcie1516_do_ioctl(struct pci_dev * pdev, unsigned int cmd, unsigned long arg);





#endif // __APCIE1516_API_H_
