 /* @file apcie1516.h
  * 
  * @brief Define the public API for the apcie1516 ADDI-DATA board. 
  * 
  * @author Sylvain Nahas, Julien Krauth
  */

/** @par LICENCE
 * 
 *  @verbatim
   Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
   ADDI-DATA GmbH
   Airpark Business Center
   Airport Boulevard B210
   77836 Rheinmnster
   Germany
   Tel: +49(0)7229/1847-0
   Fax: +49(0)7229/1847-200
   http://www.addi-data-com
   info@addi-data.com
 
 This library is free software; you can redistribute it and/or modify it under 
 the terms of the GNU Lesser General Public License as published by the 
 Free Software Foundation; either version 2.1 of the License, 
 or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 or FITNESS FOR A PARTICULAR PURPOSE. 
 See the GNU Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public License 
 along with this library; if not, write to the Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 
 
 You also shoud find the complete LGPL in the LGPL.txt file accompanying 
 this source code.
 
 @endverbatim
**/

#ifndef __APCIE1516_H__
#define __APCIE1516_H__


#include <apci.h>

//GENERAL DEFINE

#define APCIE1516_BOARD_NAME                      "APCIE1516"

#define APCIE1516_BOARD_VENDOR_ID                 0x15B8
#define APCIE1516_BOARD_DEVICE_ID                 0x1010

/**@def APCIE1516_READREG 
 * Read register offset (channel 0 - 7).
 */
#define APCIE1516_READREG			0x00

/**@def APCIE1516_WRITE 
 * Write register offset (channel 0 - 7).
 */
#define APCIE1516_WRITEREG			0x20

/* value used for CMD_APCIE1516_CheckAndGetPCISlotNumber ! DEPRECATED ! */
#ifndef CONFIG_APCIE1516_MAX_BOARD_NBR
#define CONFIG_APCIE1516_MAX_BOARD_NBR                   (3)
#endif // CONFIG_APCIE1516_MAX_BOARD_NBR

// for compatibility with older driver (deprecated)
#define APCIE1516_MAX_BOARD_NBR CONFIG_APCIE1516_MAX_BOARD_NBR

// IOCTL define part
#define APCIE1516_MAGIC (char) 'A'

/**
 * @param (char*) area of size CONFIG_APCIE1516_MAX_BOARD_NBR+1
 * 
 * @deprecated
 * 
 */
#define CMD_APCIE1516_CheckAndGetPCISlotNumber   _IOR(APCIE1516_MAGIC, 1,char*)

#define CMD_APCIE1516_SetBoardInformation        _IOW(APCIE1516_MAGIC, 2,USHORT)

/**
 * @deprecated
 */
#define CMD_APCIE1516_GetHardwareInformation     _IOR(APCIE1516_MAGIC, 3,str_BaseInformations*)

/** Read all digital inputs of the APCI-1516.
 *
 * @param [out]		arg		Function argument. An unsigned char that will contain port state.
 *
 * @retval 0		No error. 
 * @retval -EFAULT	Can't return parameters.
 */
	#define CMD_APCIE1516_Read8DigitalInputs			_IOR(APCIE1516_MAGIC, 4, unsigned char *)

/** Set all digital outputs of the APCI-1516 on.
 *
 * @param [in]		arg		Function argument. An unsigned char that has contain port state to set.
 *
 * @retval 0		No error. 
 * @retval -EFAULT	Can't return parameters.
 */
#define CMD_APCIE1516_Set8DigitalOutputsOn		_IOW(APCIE1516_MAGIC, 5, unsigned char)

/** Set all digital outputs of the APCI-1516 off.
 *
 * @param [in]		arg		Function argument. An unsigned char that has contain port state to reset.
 *
 * @retval 0		No error. 
 * @retval -EPERM	Output memory is not activated.
 * @retval -EFAULT	Can't return parameters.
 */
#define CMD_APCIE1516_Set8DigitalOutputsOff		_IOW(APCIE1516_MAGIC, 6, unsigned char)

/** Set the digital output memory on.
 *
 * @param 			arg		Non arg, it can be NULL.
 *
 * @retval 0		No error.
 */
#define CMD_APCIE1516_SetDigitalOutputMemoryOn	_IO(APCIE1516_MAGIC, 7)

/** Set the digital output memory off.
 *
 * @param 			arg		Non arg, it can be NULL.
 *
 * @retval 0		No error.
 */
#define CMD_APCIE1516_SetDigitalOutputMemoryOff	_IO(APCIE1516_MAGIC, 8)

/** Get all digital outputs states of the APCI-1516.
 *
 * @param [out]		arg		Function argument. An unsigned char that contain port state.
 *
 * @retval 0		No error. 
 * @retval -EFAULT	Can't return parameters.
 */
#define CMD_APCIE1516_Get8DigitalOutputStatus	_IOR(APCIE1516_MAGIC, 9, unsigned char *) 

/** Used internally. This is the ioctl CMD with the highest number.
 * @internal
 */
#define __APCIE1516_UPPER_IOCTL_CMD 9

#endif // __APCI1516_H__
