 /* @file api.h
  * 
  * @brief Mainly this header should contains definition of ioctl handler. 
  * 
  * 
  * 
  */

/** @par LICENCE
 * 
 *  @verbatim
  Copyright (C) 2009 ADDI-DATA GmbH for the source code of this module.
  
        ADDI-DATA GmbH
        Airpark Business Center
        Airport Boulevard B210
        77836 Rheinmuenster
        Germany
        Tel: +49(0)7229/1847-0
        Fax: +49(0)7229/1847-200
        http://www.addi-data-com
        info@addi-data.com
 
 This library is free software; you can redistribute it and/or modify it under 
 the terms of the GNU Lesser General Public License as published by the 
 Free Software Foundation; either version 2.1 of the License, 
 or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 or FITNESS FOR A PARTICULAR PURPOSE. 
 See the GNU Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public License 
 along with this library; if not, write to the Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 
 
 You also shoud find the complete LGPL in the LGPL.txt file accompanying 
 this source code.
 
 @endverbatim
**/

#ifndef __APCIE2200_API_H_
#define __APCIE2200_API_H_

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/* deprecated */
int do_CMD_APCIE2200_CheckAndGetPCISlotNumber(struct pci_dev * pdev,unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_GetHardwareInformation(struct pci_dev * pdev, unsigned int cmd, unsigned long arg);

//------------------------------------------------------------------------------
int do_CMD_APCIE2200_SetBoardInformation(struct pci_dev * pdev, unsigned int cmd, unsigned long arg);

/* Digital inputs functions (dig_inputs.c) */
int do_CMD_APCIE2200_Read16DigitalInputs(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);

int do_CMD_APCIE2200_InitAndStartDigitalInputInterrupt(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_ClearAndStopDigitalInputInterrupt(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_GetDigitalInputInterruptConfig(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
	
int do_CMD_APCIE2200_EventEmpty(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_EventWait(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_GetNumberOfDigitalInputs(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);

/* Digital outputs functions (dig_outputs.c) */
int do_CMD_APCIE2200_Set16DigitalOutputsOn(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_Set16DigitalOutputsOff(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_SetDigitalOutputMemoryOn(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_SetDigitalOutputMemoryOff(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_Get16DigitalOutputStatus(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_GetNumberOfDigitalOutputs(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);

/* Timer and watchdog (timer_watchdog.c) */
int do_CMD_APCIE2200_TimerWatchdogInitAndStart(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_TimerWatchdogStopAndRelease(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_TimerWatchdogTrigger(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_TimerWatchdogRead(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);
int do_CMD_APCIE2200_TimerWatchdogGetStatus(struct pci_dev *pdev, unsigned int cmd, unsigned long arg);

/** Execute a command in user space.
*
* @param pdev Pointer to a device.
* @param cmd Command to execute
* @param arg Argument of the command.
*/
int apcie2200_do_ioctl(struct pci_dev * pdev, unsigned int cmd, unsigned long arg);

#endif // __APCIE2200_API_H_
