#ifndef __APCIE2200_IOMAP_H__
#define __APCIE2200_IOMAP_H__

/* DIGITAL INPUT (BAR 3) */ 

/* read-only register 
 * D0: input 0
 * Dn: input n
 */
#define APCIE2200_DIGITAL_INPUT_REG							0x00

/* modus 1 configuration for channel 1 to 15
 * 
 * read,write
 * 
 * width: 32 bits
 * 
 * D1: modus 1 for channel 1
 * D2: modus 1 for channel 2
 * D3: modus 1 for channel 3
 * D4: modus 1 for channel 4
 * D5: modus 1 for channel 5
 * D6: modus 1 for channel 6
 * D7: modus 1 for channel 7
 * D8: modus 1 for channel 8
 * D9: modus 1 for channel 9
 * D10: modus 1 for channel 10
 * D11: modus 1 for channel 11
 * D12: modus 1 for channel 12
 * D13: modus 1 for channel 13
 * D14: modus 1 for channel 14
 * D15: modus 1 for channel 15
 *  
 * */
#define APCIE2200_DIGITAL_INPUT_INTERRUPT_MODUS1_REG			0x04 /**< control diagnostic interrupts  */

/* modus 2 configuration for channel 1 to 15
 * read,write
 * 
 * width: 32 bits
 * 
 * D1: modus 2 for channel 1
 * D2: modus 2 for channel 2
 * D3: modus 2 for channel 3
 * D4: modus 2 for channel 4
 * D5: modus 2 for channel 5
 * D6: modus 2 for channel 6
 * D7: modus 2 for channel 7
 * D8: modus 2 for channel 8
 * D9: modus 2 for channel 9
 * D10: modus 2 for channel 10
 * D11: modus 2 for channel 11
 * D12: modus 2 for channel 12
 * D13: modus 2 for channel 13
 * D14: modus 2 for channel 14
 * D15: modus 2 for channel 15
 *
 */
#define APCIE2200_DIGITAL_INPUT_INTERRUPT_MODUS2_REG			0x08


#define APCIE2200_DIGITAL_INPUT_INTERRUPT_STATUS_REG			0xC


/* global interrupt logic 
 * read,write
 * 
 * D1 
 * 0: OR 
 * 1: AND
 * 
 * D2
 * 0: disable IRQ
 * 1: enable IRQ

The behaviour of the interrupt for each input is the combination of :
* the bit modus 1 for this channel, 
* the bit modus 2 for this channel 
* and the global interrupt logic bit
 
      +-----------+-----------------+-----------------+-----------------+------------------------+
      | MODUS 1   |        0        |        1        |        0        |            1           |
      +-----------+-----------------+-----------------+-----------------+------------------------+
      | MODUS 2   |        0        |        0        |        1        |            1           |
      +-----------+-----------------+-----------------+-----------------+------------------------+
      | INTERRUPT |                 |                 |                 |                        |
      | OR LOGIC  |     DISABLE     |   RISING EDGE   |   FALLING EDGE  |       BOTH EDGES       |
      +-----------+-----------------+-----------------+-----------------+------------------------+
      | INTERRUPT |     DISABLE     |   HIGH STATUS   |   LOW STATUS    | LOW AND HIGH STATUS    |
      | AND LOGIC |                 |                 |                 |                        |
      +-----------+-----------------+-----------------+-----------------+------------------------+
*/ 

#define APCIE2200_DIGITAL_INPUT_INTERRUPT_LOGIC_REG			0x10

/* DIGITAL OUTPUT OFFSET DEFINE */
#define APCIE2200_DIGITAL_OUTPUT_REG							0x20

/* TIMERS (BAR 3) */

/* COMMON REGISTERS TO TIMER/WATCHDOG (hence TWC) */
#define APCIE2200_TIMER0_OFFSET					0x40

/* COMMON REGISTERS TO TIMER (hence TWC) */
#define APCIE2200_TIMER1_OFFSET					0x60

/* VALUE REGISTER
 * 
 * D0-D32: current value of the TCW
 * 
 */
#define APCIE2200_TCW_VALUE_REG								0

/* RELOAD VALUE REGISTER
 * 
 * D0-D32: reload value of the TCW
 * 
 */
#define APCIE2200_TCW_RELOAD_VALUE_REG						0x04

/* TIME BASE FOR TIMER/WATCHDOG
				1 : us
				2 : ms
				3 : s
*/
#define APCIE2200_TCW_TIME_BASE_REG							0x08

/* Timer/watchdog control register
 * 
 *  
 * 
  Write
	D0: Enable/Disable Timer
	D1: Enable/Disable IRQ
	D2: Not used
	D3: Not used
	D4: Watchdog / Timer selection (Timer1: 1: Used / 0: Not used)
		0: Watchdog
		1: Timer
	D5: Not used
	D6: Not used
	D7: Not used
	D8: Not used
	D9: Software trigger
	D10: Not used
	D11: Not used
	D12: Not used
	D13-D15: Timer mode, only mode 2 (0x02)
	
  Read
	D0: Enable/Disable Timer
	D1: Enable/Disable IRQ
	D2: Not used
	D3: Not used
	D4: Watchdog / Timer selection
		0: Watchdog
		1: Timer
	D5: Not used
	D6: Not used
	D7: Not used
	D8: Not used
	D9: Not used
	D10: Not used
	D11: Not used
	D12: Not used
	D13-D15: Timer mode, only mode 2 (0x02)
*/

#define APCIE2200_TCW_CONTROL_REG							0x0C

/* STATUS REGISTER
 * Read
 * D0: Overflow
 * 				0 : No overflow occurs
				1 : Overflow occurs
 * D1: status software trigger (read)
 * 				0 : No software trigger occur (Read)
				1 : Software trigger occur
 */
#define APCIE2200_TCW_STATUS_REG								0x10

/* IRQ STATUS REGISTER
 * 
 * D0: (read)
 * 				0 : No interrupt occur
				1 : Interrupt occur
 * 
 */
#define APCIE2200_TCW_IRQ_REG									0x14

#endif // __APCIE2200_IOMAP_H__
