/** @par LICENCE
* @verbatim
   Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
   ADDI-DATA GmbH
   Airpark Business Center
   Airport Boulevard B210
   77836 Rheinmuenster
   Germany
   Tel: +49(0)7229/1847-0
   Fax: +49(0)7229/1847-200
   http://www.addi-data-com
   info@addi-data.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. 
        
    You shoud find the complete GPL in the COPYING file accompanying 
    this source code. 
* @endverbatim
*/

#ifndef __TCW_H__
#define __TCW_H__

static inline void tcw_trigger (unsigned long base_address)
{
	uint32_t val = inl (base_address + APCIE2200_TCW_CONTROL_REG);

	val = (val | (1 << 9));
	outl (val, base_address + APCIE2200_TCW_CONTROL_REG);
}

static inline void tcw_set_control_register (unsigned long base_address, register uint32_t val)
{
	outl (val, base_address + APCIE2200_TCW_CONTROL_REG);
}

static inline uint32_t tcw_read_value (unsigned long base_address)
{
	return inl (base_address + APCIE2200_TCW_VALUE_REG);
}

static inline uint32_t tcw_get_status (unsigned long base_address)
{
	return (inl (base_address + APCIE2200_TCW_STATUS_REG) & 0x00000002);
}

static inline void tcw_set_reload_value (unsigned long base_address, uint32_t reload_value)
{
	outl (reload_value, base_address + APCIE2200_TCW_RELOAD_VALUE_REG);
}

static inline void tcw_set_time_base (unsigned long base_address, uint32_t time_base)
{
	outl (time_base, base_address + APCIE2200_TCW_TIME_BASE_REG);
}

static inline uint32_t tcw_get_interrupt_status (unsigned long base_address)
{
	return (0x1 & (inl (base_address + APCIE2200_TCW_IRQ_REG)));
}

#endif // __TCW_H__
