#ifndef __APCIE2200_EVENTS_H__
#define __APCIE2200_EVENTS_H__

/* @file apcie2200-events.h
  * 
  * @brief Defines the event type for the board. 
  * 
  * This board implement a event system that allows a user-mode process (or thread) to know when a specific change happened on the board.
  * 
  * This is done by using a blocking ioctl call.  
  *
  */

/** @par LICENCE
 * 
 *  @verbatim
   Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
   ADDI-DATA GmbH
   Airpark Business Center
   Airport Boulevard B210
   77836 Rheinmuenster
   Germany
   Tel: +49(0)7229/1847-0
   Fax: +49(0)7229/1847-200
   http://www.addi-data-com
   info@addi-data.com
 
 This library is free software; you can redistribute it and/or modify it under 
 the terms of the GNU Lesser General Public License as published by the 
 Free Software Foundation; either version 2.1 of the License, 
 or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 or FITNESS FOR A PARTICULAR PURPOSE. 
 See the GNU Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public License 
 along with this library; if not, write to the Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 
 
 You also shoud find the complete LGPL in the LGPL.txt file accompanying 
 this source code.
 
 @endverbatim
**/

typedef enum
{
	APCIE2200_EVT_FROM_DIGITAL_INPUT,
	APCIE2200_EVT_FROM_TIMER,
	APCIE2200_EVT_FROM_WATCHDOG
} event_source_t;

typedef struct
{
	event_source_t source; /**< the subsystem that generated the event */
	unsigned long param1;  /**< APCIE2200_EVT_FROM_DIGITAL_INPUT: This is the bitmask of digital inputs that generated the event.
	                            APCIE2200_EVT_FROM_TIMER: Nothing
	                            APCIE2200_EVT_FROM_WATCHDOG: Nothing */
	unsigned long param2; /**< Not used at this time */
} apcie2200_event_t;


#endif /*__APCIE2200_EVENTS_H__*/
