#ifndef __APCIE2200_PRIVATE__
#define __APCIE2200_PRIVATE__

/** @file apcie2200-private.h
*
* @author Sylvain Nahas
*
* This header contains private definitions (not to be seen by external code)
*/

/** @par LICENCE
* @verbatim
 Copyright (C) 2009 ADDI-DATA GmbH for the source code and the documentation.

        ADDI-DATA GmbH
        Airpark Business Center
        Airport Boulevard B210
        77836 Rheinm�nster
        Germany
        Tel: +49(0)7229/1847-0
        Fax: +49(0)7229/1847-200
        http://www.addi-data-com
        info@addi-data.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You shoud find the complete GPL in the COPYING file accompanying
    this source code.
* @endverbatim
*/

#include <linux/version.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,19)
	#include <linux/config.h>
#else
	#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,33)
		#include <linux/autoconf.h>
	#else
		#include <generated/autoconf.h>
	#endif
#endif

#include <linux/spinlock.h>
#include <linux/ioctl.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/pci.h> // struct pci_dev
#include <asm/io.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(3,4,0)
	#include <asm/system.h>
#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(4,12,0)
	#include <asm/uaccess.h>
#else
	#include <linux/uaccess.h>
#endif
#include <asm/bitops.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/proc_fs.h>

#include <apci.h>
#include <apcie2200.h>
#include "iomap.h"

/** ressources of a board */

static __inline__ unsigned long GET_BAR0(struct pci_dev * dev)
{
	return dev->resource[0].start;
}

static __inline__ unsigned long GET_BAR1(struct pci_dev * dev)
{
	return dev->resource[1].start;
}

static __inline__ unsigned long GET_BAR2(struct pci_dev * dev)
{
	return dev->resource[2].start;
}

static __inline__ unsigned long GET_BAR3(struct pci_dev * dev)
{
	return dev->resource[3].start;
}

/** Utility fonction that returns 0 if the given index corresponds to a card already configured.
 *
 * @param count Number of board
 * @param index Minor number to check
 *
 * @return 0 if minor number valid, not 0 otherwise
 *
 * count ranges from 1 to ...
 * index ranges from 0 to ...
 *
 * */

static __inline__ int apcie2200_INDEX_NOT_VALID(atomic_t * count , unsigned int index )
{
	volatile unsigned int __count =  atomic_read(count);
	if (index >= __count) return 1;
	return 0;

}


/* number of board detected by the kernel */
extern atomic_t apcie2200_count;

#define __DRIVER_NAME "apcie2200"

/* major number (attributed by the OS) */
extern unsigned int apcie2200_majornumber;



/* dev function */
int apcie2200_open_lookup (struct inode *inode, struct file *filp);
int apcie2200_release_lookup (struct inode *inode,struct file *filp);
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,36)
int apcie2200_ioctl_lookup (struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg);
#else
long apcie2200_ioctl_lookup (struct file *filp, unsigned int cmd, unsigned long arg);
#endif

/* kernel-side accessible API */
//int apcie2200_do_ioctl(struct pci_dev * pdev, unsigned int cmd, unsigned long arg);

/*/proc functions  */
void apcie2200_proc_init(void);
void apcie2200_proc_release(void);
void apcie2200_proc_create_device(struct pci_dev * dev, unsigned int minor_number);
void apcie2200_proc_release_device(struct pci_dev * dev);

/* interrupt related function */
int apcie2200_register_interrupt(struct pci_dev * pdev);
int apcie2200_deregister_interrupt(struct pci_dev * pdev);


#include "api.h"
#include "privdata.h"

#define APCIE2200_DISABLE									(0)
#define APCIE2200_ENABLE									(1)

#endif //__APCIE2200_PRIVATE__
