REDHAT_OS      := $(shell cat /etc/os-release | grep ^NAME | grep -i -e 'red hat enterprise' -e centos -e almalinux -e rocky -e oracle)
OS_VERSION     := $(shell cat /etc/os-release | grep VERSION_ID | cut -d= -f2 | sed 's/"//g' | cut -d. -f1)
KERNEL_VERSION := $(shell uname -r | cut -d- -f1 | sed 's/\.//g')
KERNEL_RELEASE := $(shell uname -r | cut -d- -f2 | cut -d. -f1)

#$(info $(REDHAT_OS))
#$(info $(OS_VERSION))
#$(info $(KERNEL_VERSION))
#$(info $(KERNEL_RELEASE))

ifneq ($(REDHAT_OS),)
  $(info RedHat like family detected)
  ifeq ($(OS_VERSION),9)
    $(info Version 9 detected)
    ifeq ($(shell [ $(KERNEL_VERSION) -eq 5140 ] && echo true || echo false), true)
      ifeq ($(shell [ $(KERNEL_RELEASE) -ge 387 ] && echo true || echo false), true)
        $(info Backport detected)
	REDHAT_FLAG := CC="cc -DRHEL9_BACKPORT"
      endif
     else
       ifeq ($(shell [ $(KERNEL_VERSION) -gt 5140 ] && echo true || echo false), true)
        $(info Backport detected)
	REDHAT_FLAG := CC="cc -DRHEL9_BACKPORT"
       endif
     endif
  endif
endif

