# ADDI-DATA Linux driver (copyright 2014-2021 - ADDI-DATA GmbH)

## 1 - INTRODUCTION

The driver is designed as a kernel module compliant with kernel from version 2.4 to 5.x.  
It may contain ioctl functions that can be called from a user level application, and exported kernel functions that can be called in another kernel module.  
The driver can be adapted to be used with realtime patches like RTAI.

## 2 - INSTALLATION

To be compiled, the driver uses the kernel compilation process.  
Driver sources have generally to be installed and built in the kernel sources directory.  
But, they can be installed and built out of kernel sources.

### 2.1 - Installation for building in kernel sources

- Copy the driver package into e.g. your /tmp directory:

  ```
  /tmp/apci1710_rXXX.tar.bz2
  ```

- Untar the package archive:

  ```bash
  tar -jvxf /tmp/apci1710_rXXX.tar.bz2
  ```

  This will extract driver sources under:

  ```
  /tmp/apci1710_rXXX
  ```

- Move headers into the kernel sources:

  ```bash
  mv /tmp/apci1710_rXXX/include/linux/addidata /usr/src/linux/include/linux/
  ```

- Move the driver code into the kernel sources:

  ```bash
  mv /tmp/apci1710_rXXX/drivers/addidata /usr/src/linux/drivers/
  ```

### 2.2 - Installation for building out of kernel sources

- Extract the package where you want e.g.: /tmp
- Copy the driver package into e.g. your tmp directory:

  ```
  /tmp/apci1710_rXXX.tar.bz2
  ```

- Untar the package archive:

  ```bash
  tar -jvxf /tmp/apci1710_rXXX.tar.bz2
  ```

  This will extract driver sources under:

  ```
  /tmp/apci1710_rXXX
  ```

## 3 - CONFIGURATION AND COMPILATION

### 3.1 - Building in kernel sources

If you have a link called linux, pointing on /usr/src/linux, and that you correctly installed sources, you don't have to configure anything.  
Else please read the following section.

### 3.2 - Building out of kernel sources

In `apci1710_rXXX/drivers/addidata/apci1710/`, edit the `_makefile` file, you will see both fields:

```make
###################################################################
# relative path of the source of the kernel to build against
# IF YOU ARE BUILDING THIS DRIVER OUTSIDE THE KERNEL SOURCE
# PLEASE ADAPT THIS VARIABLE TO YOUR LOCAL INSTALLATION
ifeq ($(KERNELSRCDIR),)
KERNELSRCDIR:=/lib/modules/$(shell uname -r)/build
endif
####################################################################

####################################################################
# relative path of the addidata include directory
# IF YOU ARE BUILDING THIS DRIVER OUTSIDE THE KERNEL SOURCE
# PLEASE ADAPT THIS VARIABLE TO YOUR LOCAL INSTALLATION
ifeq ($(ADDIDATAINC),)
ADDIDATAINC:=$(shell pwd)/../../../include/linux/addidata
endif
####################################################################
```

- KERNELSRCDIR is the path of kernel sources (by default, it will point to current loaded kernel).
- ADDIDATAINC is the path of ADDI-DATA driver header.

Edit these values if they are not correct.

To compile the driver, go into the driver sources directory (e.g. `apci1710`) and type:

- For kernel 2.4:

  ```bash
  make -f _makefile 2.4
  ```

- For kernel 2.6 and upper:

  ```bash
  make -f _makefile 2.6
  ```

## 4 - LOADING / UNLOADING THE DRIVER MANUALLY

Remark: Those operations will probably require root privileges.

### Kernel 2.4

- Load:

  ```bash
  insmod apci1710.o
  ```

- Unload:

  ```bash
  rmmod apci1710
  ```

### Kernel 2.6 and upper

- Load:

  ```bash
  insmod apci1710.ko
  ```

- Unload:

  ```bash
  rmmod apci1710
  ```

### 4.1 - IS THE DRIVER LOADED?

You can check if the driver has been successfully loaded with the command `lsmod`.  
The names of the loaded drivers appear.

Remark: for more information about `lsmod`, use `man lsmod`.

## 5 - LOADING THE DRIVER AUTOMATICALLY AT BOOT TIME

Remark: Those operations will probably require root privileges.

Maybe you want to load the driver at each boot automatically.

- Go into your driver sources directory, e.g.: `/tmp/apci1710/`
- Then, launch these simple commands:

  ```bash
  make -f _makefile install_26
  depmod -ae
  ```

This will copy the module in the subdirectory:

```
/lib/modules/<kernel_version_of_the_kernel_you_are_building>/extra/
```

with a Debian system.

And create the udev rules under `/etc/udev/addidata.rules` and a link under `/etc/udev/rules.d/addidata.rules`.

### 5.1 - IS THE DRIVER INSTALLED?

You can check if the driver file takes place in one of the subdirectories of:

```
/lib/modules/<kernel_version_of_the_kernel_you_are_building>
```

e.g.: `/lib/modules/2.6.15`

To do so, launch the following command:

```bash
find /lib/modules/<kernel_version_of_the_kernel_you_are_building> -name <name_of_the_module>
```

- For a 2.4 kernel:

  ```bash
  find /lib/modules/2.4.27 -name apci1710.o
  ```

- For a 2.6 and upper kernel:

  ```bash
  find /lib/modules/2.6.15 -name apci1710.ko
  ```

If there is no result, it means that something failed.

### 5.2 - Tell the OS to load the driver at boot time

Kernel 2.4, 2.6, 3.x, 4.x and 5.x:

- Edit the file `/etc/modules`, and add the name of the module, e.g. `apci1710`,
  or simply use the command:

  ```bash
  echo "apci1710" | sudo tee -a /etc/modules
  ```

You probably have to be root.  
If you do not find the `/etc/modules` file, please refer to your distribution documentation (`man modules`).

## 6 - SAMPLES

One or more samples are available.  
They are located in the `samples` directory.  
To build them, go into the driver samples sources directory:

```bash
make -f _makefile samples
```

Remark: Before running them, the driver has to be loaded.

## 7 - TROUBLESHOOTING

### 7.1 - CONFLICT WITH COMEDI

The Comedi project (<https://comedi.org/>) develops open-source drivers, tools, and libraries for data acquisition.  
Since kernel 2.6.30, Comedi drivers are included in kernel tree.  
Depending on the kernel and/or Linux distribution you are using, the Comedi drivers can be loaded automatically and detect Addi-Data boards.  
If Comedi driver is loaded, it prevents the current driver from detecting any installed board and to work with.  
This case can be verified by using the command `lspci -k`.  
There is a workaround which consists of blacklisting the Comedi driver.  
Create or edit the `/etc/modprobe.d/blacklist.conf` file. Add the following lines and reboot the computer.

```conf
blacklist comedi
blacklist comedi_pci
blacklist addi_apci_1710
```

## 8 - FUNCTION MODULES

### 8.1 - set171x Software

Set171x software is provided with your 171X cards and is used to customize and deploy function modules, as well as to change the Master Version on 1711 cards.  
For further information concerning function modules, please refer to the README for your card (1710, 1711).

### 8.2 - Supported Function Modules

| Module / Function          | Win 1710 HEX | Win 1711 HEX | Linux HEX | ID | Comment                                      |
|---------------------------:|:------------:|:------------:|:---------:|:--:|----------------------------------------------|
| Incremental Counter        | 5343         | 5343         | 5343      | SC | Both 1710 / 1711 and both OS                 |
| SSI Counter                | 5349         | 5349         | 5349      | SI | Both 1710 / 1711 and both OS                 |
| TTL IO                     | 544C         | 544C         | 544C      | TL | Both 1710 / 1711 and both OS                 |
| Digital IO                 | 4449         | 4449         | 4449      | DI | Both 1710 / 1711 and both OS                 |
| 82X54 Timer                | 4943         | 4943         | 4943      | IC | Both 1710 / 1711 and both OS                 |
| PWM                        | 5057         | 5057         | 5057      | PW | Both 1710 / 1711 and both OS                 |
| ETM                        | 4554         | 4554         | 4554      | ET | Both 1710 / 1711 and both OS                 |
| Chronometer                | 4348         | —            | 4348      | CH | 1710 FM                                      |
| Pulse Encoder              | 495A         | —            | 495A      | IZ | 1710 FM                                      |
| TOR Counter                | 544F         | —            | 544F      | TO | 1710 FM                                      |
| CDA                        | 4344         | —            | 4344      | CD | 1710 FM                                      |
| BiSS Master                | —            | 424D         | 424D      | BM | 1711 FM                                      |
| EnDat                      | —            | 454E         | 454E      | EN | 1711 FM                                      |
| Parallel Interface         | —            | 5049         | —         | PI | 1711 FM // Windows only                      |
| SinCos                     | —            | 534E         | —         | SN | 1711 FM // Windows only                      |
| Tamagawa                   | —            | 5457         | —         | TW | 1711 FM // Windows only                      |
| SpeedBox                   | —            | —            | 5342      | SB | Deprecated / Not used / old version of IC    |
| Ballistic                  | 4241         | —            | 4241      | BA | OldDriver DLL FM                             |
| PTP                        | —            | —            | 5054      | PT | Deprecated / Not used / old version of PWM   |

### 8.3 - Missing or need a new Function Module?

In that case, please contact Addi Data via email: <info@addi-data.com>.  
We will assess the possibility of adding or updating the corresponding function module.

## 9 - GENERAL INFORMATION

### Addi Pack support

Since the end of 2025, Addi Pack has been released. Addi Pack is a cross-platform environment that contains drivers and a unified API for Addi-Data products.  
Addi Pack is planned to support all Addi-Data devices, including the 17XX series.  
Device compatibility is available in the Addi Pack documentation, available from the Addi-Data website.

Using Addi Pack for new projects is encouraged to ensure access to the latest updates and reliable LTS.

### Other Information

In the ADDI-DATA header directory (default: `/usr/src/linux/include/linux/addidata/`):

- See `apci1710.h` for description of the IOCTL commands provided.
- See `apci1710-kapi.h` for description of the kernel functions provided.

These two commands are deprecated since there is possibility to retrieve the same information from OS facilities:

- `CMD_APCI1710_CheckAndGetPCISlotNumber`
- `CMD_APCI1710_GetHardwareInformation`

For each board detected the driver dynamically creates a special character device file in `/proc/sys/apci1710` (kernel 2.4).

- The major device number is provided by the operating system.
- The minor device number is actually the ordinal in the PCI device list (order of detection)
- The name of the file is the PCI slot identification: BUS/SLOT/FUNCTION in hexadecimal

On kernel >= 2.6, special character device file in `/proc/sys/` are no more allowed, a node is created under `/dev/apci1710`.

Warning: This driver has not been tested with a true PCI hotplug system.

For any request or remark please contact us:  
<info@addi-data.com>
