/** @file sample_endat_01.c
*
* @author El Bakali Laaziz
* Get Position Values
*
*  i_APCI1711_EndatResetErrorBits
*  i_APCI1711_EndatInitialiseSensor
*  i_APCI1711_EndatSensorSendPositionValue
*/

/** @par LICENCE
* @verbatim
    Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
    ADDI-DATA GmbH
    Airpark Business Center
    Airport Boulevard B210
    77836 Rheinmuenster
    Germany
    Tel: +49(0)7229/1847-0
    Fax: +49(0)7229/1847-200
    http://www.addi-data-com
    info@addi-data.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. 

    You shoud find the complete GPL in the COPYING file accompanying 
    this source code.
* @endverbatim
*/

#include <linux/version.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,19)
    #include <linux/config.h>
#else
    #if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,33)
        #include <linux/autoconf.h>
    #else
        #include <generated/autoconf.h>
    #endif
#endif

#include <linux/spinlock.h>
#include <linux/ioctl.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/pci.h> // struct pci_dev
#include <asm/io.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(3,4,0)
    #include <asm/system.h>
#endif
#include <asm/uaccess.h>
#include <asm/bitops.h>
#include <linux/sched.h>

#include <linux/interrupt.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/proc_fs.h>

#include <apci1710.h>
#include <apci1710-kapi.h>

MODULE_LICENSE("GPL");
MODULE_AUTHOR("ADDI-DATA GmbH <info@addi-data.com>");
MODULE_DESCRIPTION("APCI-1710");

EXPORT_NO_SYMBOLS;

static const char modulename[] = "sample_endat";


static int sample_endat_kernel (struct pci_dev *pdev)
{
    int ret = 0;

    // Value fixed by user
    uint8_t moduleIndex = 0;
    uint8_t sensorIndex = 0;
    uint32_t frequency = 1000;


    uint32_t positionLow = 0;
    uint32_t positionHigh = 0;
    uint32_t positionSz = 0;

    int i = 0;

    /* reset the error bits */
    ret = i_APCI1711_EndatResetErrorBits(pdev, moduleIndex, sensorIndex);
    if (ret != 0)
    {
        printk("i_APCI1711_EndatResetErrorBits, error : %d \n", ret);
        return 1;
    }

    /* initialise the EnDat sensor */
    ret = i_APCI1711_EndatInitialiseSensor(pdev, moduleIndex, sensorIndex, frequency);

    if ( ret != 0 )
    {
        printk("i_APCI1711_EndatInitialiseSensor, error : %d \n", ret);
        return 1;
    }

    for (i=0; i<100; i++)
    {

        /* Read position the EnDat sensor */
        ret = i_APCI1711_EndatSensorSendPositionValue(pdev, moduleIndex, sensorIndex, &positionLow, &positionHigh, &positionSz);

        if (ret != 0)
        {
            printk("i_APCI1711_EndatSensorSendPositionValue, error : %d \n", ret);
            return 1;
        }

        printk ("Position low: 0x%x \thigh: 0x%x \tsize: 0x%x\n", positionLow, positionHigh, positionSz);

        mdelay (100);
    }

    return 0;
}



/** Called when module loads. */
static int __init apci1710Sample_init(void)
{
    struct pci_dev *pdev;
    int board_index = 0;

    printk("%s: looking for board %u\n",modulename,board_index);

    pdev = apci1710_lookup_board_by_index(0);

    if (!pdev)
    {
        printk("%s: board %u not found\n",modulename,board_index);
        return -ENODEV;
    }

    sample_endat_kernel(pdev);

    return 0;
}
//-------------------------------------------------------------------
/** Called when module is unloaded. */
static void __exit apci1710Sample_exit(void)
{


}
//------------------------------------------------------------------------------
module_exit(apci1710Sample_exit);
module_init(apci1710Sample_init);
