/** @file sample_endat_01.c
*
* @author El Bakali Laaziz
*
* Windows sample : GetPositionValuesWithAdditionalData
* i_APCI1711_EndatResetErrorBits
* i_APCI1711_EndatInitialiseSensor
* i_APCI1711_EndatSelectAdditionalData
* i_APCI1711_EndatSensorSendPositionValueWithAdditionalData
*/

/** @par LICENCE
* @verbatim
    Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.

    ADDI-DATA GmbH
    Airpark Business Center
    Airport Boulevard B210
    77836 Rheinmuenster
    Germany
    Tel: +49(0)7229/1847-0
    Fax: +49(0)7229/1847-200
    http://www.addi-data-com
    info@addi-data.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You shoud find the complete GPL in the COPYING file accompanying
    this source code.
* @endverbatim
*/

#include <linux/version.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,19)
    #include <linux/config.h>
#else
    #if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,33)
        #include <linux/autoconf.h>
    #else
        #include <generated/autoconf.h>
    #endif
#endif

#include <linux/spinlock.h>
#include <linux/ioctl.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/pci.h> // struct pci_dev
#include <asm/io.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(3,4,0)
    #include <asm/system.h>
#endif
#include <asm/uaccess.h>
#include <asm/bitops.h>
#include <linux/sched.h>

#include <linux/interrupt.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/proc_fs.h>

#include <apci1710.h>
#include <apci1710-kapi.h>

MODULE_LICENSE("GPL");
MODULE_AUTHOR("ADDI-DATA GmbH <info@addi-data.com>");
MODULE_DESCRIPTION("APCI-1710");

EXPORT_NO_SYMBOLS;

static const char modulename[] = "sample_endat";

static int sample_endat_kernel (struct pci_dev *pdev)
{
    int i_ReturnValue = 0;

    //Value fixed by the user, see the documentation of endat for the value
    uint8_t moduleIndex = 0;
    uint8_t sensorIndex = 0;
    uint32_t frequency = 1000;
    uint32_t addDataCount = 2; //(0->2)
    uint32_t mrsCodeAI1 = 0x40; //0x40 to 0x4E
    uint32_t mrsCodeAI2 = 0x51; //0x50 to 0x5B
    
    int i = 0;

    /* reset the error bits */
    i_ReturnValue = i_APCI1711_EndatResetErrorBits(pdev, moduleIndex, sensorIndex);
    if ( i_ReturnValue != 0 )
    {
        printk("i_APCI1711_EndatResetErrorBits, error : %d \n", i_ReturnValue);
        return 1;
    }
    printk("i_APCI1711_EndatResetErrorBits: ok. \n");

    /* initialise the EnDat sensor */
    i_ReturnValue = i_APCI1711_EndatInitialiseSensor(pdev, moduleIndex, sensorIndex,frequency);
    if ( i_ReturnValue != 0 )
    {
        printk("i_APCI1711_EndatInitialiseSensor, error : %d \n", i_ReturnValue);
        return 1;
    }
    printk("i_APCI1711_EndatInitialiseSensor: ok. \n");


    /* select the additional data */
    i_ReturnValue = i_APCI1711_EndatSelectAdditionalData(pdev, moduleIndex, sensorIndex, (uint8_t)addDataCount, mrsCodeAI1, mrsCodeAI2);
    if ( i_ReturnValue != 0 )
    {
        printk("i_APCI1711_EndatSelectAdditionalData, error : %d \n", i_ReturnValue);
        return 1;
    }
    printk("i_APCI1711_EndatSelectAdditionalData: ok. \n");

    /*loop*/
    for(i = 0;i<100;i++)
    {
        uint32_t positionLow = 0;
        uint32_t positionHigh = 0;
        uint32_t positionSz = 0;
        uint32_t additionalData1 = 0;
        uint32_t additionalData2 = 0;

        i_ReturnValue = i_APCI1711_EndatSensorSendPositionWithAdditionalData(pdev,moduleIndex,sensorIndex, &positionLow,&positionHigh, &positionSz,&additionalData1,&additionalData2);
        if ( i_ReturnValue != 0 )
        {
            printk("i_APCI1711_EndatSensorSendPositionValueWithAdditionalData, error : %d \n", i_ReturnValue);
            return 1;
        }


        printk ("Position low: 0x%x \thigh: 0x%x \tsize: 0x%x\n", positionLow, positionHigh, positionSz);

        if ( addDataCount >= 1 )
        {
            printk("Additional data 1 : 0x%X \n", additionalData1);
        }
        if ( addDataCount == 2 )
        {
            printk("Additional data 2 : 0x%X \n", additionalData2);
        }

        msleep (100);

    }

    return 0;
}


/** Called when module loads. */
static int __init apci1710Sample_init(void)
{
    struct pci_dev *pdev;
    int board_index = 0;

    pdev=apci1710_lookup_board_by_index(0);
    if( !pdev )
    {
        printk("%s: board %u not found\n",modulename,board_index);
        return -ENODEV;
    }
    printk("%s: beginning test\n",modulename);
    sample_endat_kernel (pdev);

    return 0;
}
//-------------------------------------------------------------------
/** Called when module is unloaded. */
static void __exit apci1710Sample_exit(void)
{


}
//------------------------------------------------------------------------------
module_exit(apci1710Sample_exit);
module_init(apci1710Sample_init);


