/** @file sample_ssi_04.c
*
* @author Krauth Julien
*
* SSI digital input:
* - i_APCI1710_ReadSSI1DigitalInput
* - i_APCI1710_ReadSSIAllDigitalInput
*/

/** @par LICENCE
* @verbatim
    Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
    ADDI-DATA GmbH
    Airpark Business Center
    Airport Boulevard B210
    77836 Rheinmuenster
    Germany
    Tel: +49(0)7229/1847-0
    Fax: +49(0)7229/1847-200
    http://www.addi-data-com
    info@addi-data.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. 

    You shoud find the complete GPL in the COPYING file accompanying 
    this source code.
* @endverbatim
*/

#include <linux/version.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,19)
    #include <linux/config.h>
#else
    #if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,33)
        #include <linux/autoconf.h>
    #else
        #include <generated/autoconf.h>
    #endif
#endif

#include <linux/spinlock.h>
#include <linux/ioctl.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/pci.h> // struct pci_dev
#include <asm/io.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(3,4,0)
    #include <asm/system.h>
#endif
#include <asm/uaccess.h>
#include <asm/bitops.h>
#include <linux/sched.h>

#include <linux/interrupt.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/proc_fs.h>

#include <apci1710.h>
#include <apci1710-kapi.h>

MODULE_LICENSE("GPL");
MODULE_AUTHOR("ADDI-DATA GmbH <info@addi-data.com>");
MODULE_DESCRIPTION("APCI-1710");

EXPORT_NO_SYMBOLS;

static const char modulename[] = "sample_ssi";


static int sample_ssi_kernel (struct pci_dev *pdev)
{ 

    int i_ReturnValue = 0;

    uint8_t b_ModuleNbr = 0; /* The first module */
    uint8_t b_Channel0Status = 0;
    uint8_t b_Channel1Status = 0;
    uint8_t b_Channel2Status = 0;
    uint8_t b_AllChannelStatus = 0;

    /* Read SSI digital input 0 status */
    i_ReturnValue = i_APCI1710_ReadSSI1DigitalInput (pdev,
                                                                    b_ModuleNbr,
                                                                    0,
                                                                    &b_Channel0Status);

    switch (i_ReturnValue)
    {
        case 0:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 0 OK");
            break;
    
        case 1:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 0 error");
            printk ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
            break;
    
        case 2:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 0 error");
            printk ("\nError = %d. The module parameter is wrong", i_ReturnValue);
            break;
    
        case 3:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 0 error");
            printk ("\nError = %d. The module is not a SSI module", i_ReturnValue);
            break;
    
        case 4:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 0 error");
            printk ("\nError = %d. The selected SSI digital input is wrong", i_ReturnValue);
            break;
    
        default:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 0 error");
            printk ("\nError = %d", i_ReturnValue);
            break;
    }

    /* Read SSI digital input 1 status */
    i_ReturnValue = i_APCI1710_ReadSSI1DigitalInput (pdev,
                                                                    b_ModuleNbr,
                                                                    1,
                                                                    &b_Channel1Status);

    switch (i_ReturnValue)
    {
        case 0:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 1 OK");
            break;
    
        case 1:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 1 error");
            printk ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
            break;
    
        case 2:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 1 error");
            printk ("\nError = %d. The module parameter is wrong", i_ReturnValue);
            break;
    
        case 3:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 1 error");
            printk ("\nError = %d. The module is not a SSI module", i_ReturnValue);
            break;
    
        case 4:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 1 error");
            printk ("\nError = %d. The selected SSI digital input is wrong", i_ReturnValue);
            break;
    
        default:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 1 error");
            printk ("\nError = %d", i_ReturnValue);
            break;
    }

    /* Read SSI digital input 2 status */
    i_ReturnValue = i_APCI1710_ReadSSI1DigitalInput (pdev,
                                                                    b_ModuleNbr,
                                                                    2,
                                                                    &b_Channel2Status);

    switch (i_ReturnValue)
    {
        case 0:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 2 OK");
            break;
    
        case 1:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 2 error");
            printk ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
            break;
    
        case 2:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 2 error");
            printk ("\nError = %d. The module parameter is wrong", i_ReturnValue);
            break;
    
        case 3:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 2 error");
            printk ("\nError = %d. The module is not a SSI module", i_ReturnValue);
            break;
    
        case 4:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 2 error");
            printk ("\nError = %d. The selected SSI digital input is wrong", i_ReturnValue);
            break;
    
        default:
            printk ("\ni_APCI1710_ReadSSI1DigitalInput for the SSI digital input 2 error");
            printk ("\nError = %d", i_ReturnValue);
            break;
    }


    /* Read all SSI digital inputs */
    i_ReturnValue = i_APCI1710_ReadSSIAllDigitalInput (pdev,
                                                                        b_ModuleNbr,
                                                                        &b_AllChannelStatus);

    switch (i_ReturnValue)
    {
        case 0:
            printk ("\ni_APCI1710_ReadSSIAllDigitalInput OK");
            break;
    
        case 1:
            printk ("\ni_APCI1710_ReadSSIAllDigitalInput error");
            printk ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
            break;
    
        case 2:
            printk ("\ni_APCI1710_ReadSSIAllDigitalInput error");
            printk ("\nError = %d. The module parameter is wrong", i_ReturnValue);
            break;
    
        case 3:
            printk ("\ni_APCI1710_ReadSSIAllDigitalInput error");
            printk ("\nError = %d. The module is not a SSI module", i_ReturnValue);
            break;
    
        default:
            printk ("\ni_APCI1710_ReadSSIAllDigitalInput error");
            printk ("\nError = %d", i_ReturnValue);
            break;
    }

    printk ("\nSSI digital input channel 0    = %d", b_Channel0Status);
    printk ("\nSSI digital input channel 1    = %d", b_Channel1Status);
    printk ("\nSSI digital input channel 2    = %d", b_Channel2Status);
    printk ("\nAll SSI digital inputs channel = %d", b_AllChannelStatus);

    return (i_ReturnValue);
}


/** Called when module loads. */
static int __init apci1710Sample_init(void)
{
    struct pci_dev *pdev;
    int board_index = 0;

    printk("%s: looking for board %u\n",modulename,board_index);
    pdev=apci1710_lookup_board_by_index(0);
    if( !pdev )
    {
        printk("%s: board %u not found\n",modulename,board_index);
        return -ENODEV;
    }
    printk("%s: beginning test\n",modulename);
        sample_ssi_kernel (pdev);

    return 0;
}
//-------------------------------------------------------------------
/** Called when module is unloaded. */
static void __exit apci1710Sample_exit(void)
{
 
    
}
//------------------------------------------------------------------------------
module_exit(apci1710Sample_exit);
module_init(apci1710Sample_init);
