#!/bin/bash
# Test if ADDI-DATA udev rules exist, if not create them.

DRIVER_NAME=apci1710

UDEVRULEFILENAME=/etc/udev/addidata.rules
UDEVRULESYMLINK=/etc/udev/rules.d/addidata.rules

if [ ! -f "$UDEVRULEFILENAME" ];
then 
        echo "File $UDEVRULEFILENAME does not exist - creating it."
        touch $UDEVRULEFILENAME
        echo "# Generated automatically by ADDI-DATA installation script" >> $UDEVRULEFILENAME 
else
        echo "File $UDEVRULEFILENAME already exists."
fi;

if [ ! -L "$UDEVRULESYMLINK" ];
then
        ln -s $UDEVRULEFILENAME $UDEVRULESYMLINK
fi

TMPSTR=`grep "SUBSYSTEMS==\"$DRIVER_NAME\"" $UDEVRULEFILENAME`
if [ "" == "$TMPSTR" ];
then 
        echo Adding rule for $DRIVER_NAME to $UDEVRULEFILENAME
        echo "SUBSYSTEMS==\"$DRIVER_NAME\", SYMLINK+=\"$DRIVER_NAME/%m\"" >> $UDEVRULEFILENAME  
        echo Reloading udev
	which udevcontrol >/dev/null 2>&1
		if [ $? -eq 0 ]; 
		then 
			udevcontrol reload_rules
		else
			udevadm control --help | grep "reload_rules" && udevadm control --reload_rules || udevadm control --reload-rules
		fi;
else
        echo A rule for $DRIVER_NAME already exists in file $UDEVRULEFILENAME
fi;
