/** @file sample_apci1710_TTL_in.c
 
   This demonstrate how to use ttl I/O in user mode.
 
   @par CREATION  
   @author Addi-data
   @date   02.09.2016
   
   @par VERSION
   @verbatim
   $LastChangedRevision:$
   $LastChangedDate:$
   @endverbatim   
   
   @par LICENCE
   @verbatim
    Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
    ADDI-DATA GmbH
    Airpark Business Center
    Airport Boulevard B210
    77836 Rheinm�nster
    Germany
    Tel: +49(0)7229/1847-0
    Fax: +49(0)7229/1847-200
    http://www.addi-data-com
    info@addi-data.com
        
   This program is free software; you can redistribute it and/or modify it under 
   the terms of the GNU General Public License as published by the Free Software 
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. 
   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with 
   this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   You shoud also find the complete GPL in the COPYING file 
   accompanying this source code.
   @endverbatim   
 */ 

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <errno.h>
#include <stdint.h>

#include <apci1710.h>

#include "sample_apci1710_common.h"

//--------------------------------------------------------------------------------

/**
 * @brief TTL input sample for APCI-1710 module
 * @param fd File descriptor of the opened APCI-1710 device
 */
void sample (int fd)
    {
    unsigned char  b_ModuleNbr = 0;     // Module number to test
    unsigned char  b_SelectedPort = 0; // Selected Port
    unsigned char  b_TTLChannel = 0;
    unsigned char  b_ChannelStatus;        // TTL input status
    int            i_ReturnValue;       // Return error code
    unsigned char  b_ArgArray[5];


    /* Print sample information */
    printf ("\n    +---------------------------------------------+");
    printf ("\n    |            APCI-1710 TTL I/O:               |");
    printf ("\n    |           TTL channel sample                |");
    printf ("\n    |        Port A, B, C, D in input mode        |");
    printf ("\n    +---------------------------------------------+");

    /* 
     * Initialise the TTL I/O module
     * Channel A, B, C and D for input
     */
     
     /* Module number to configure (0 to 3).*/
    b_ArgArray[0] = b_ModuleNbr;
    
    /*
     * Channel A mode selection
     * 0 : Channel used for digital input
     * 1 : Channel used for digital output
     */    
    b_ArgArray[1] = 0;

    /*
     * Channel B mode selection
     * 0 : Channel used for digital input
     * 1 : Channel used for digital output
     */    
    b_ArgArray[2] = 0;

    /*
     * Channel C mode selection
     * 0 : Channel used for digital input
     * 1 : Channel used for digital output
     */
    b_ArgArray[3] = 0;

    /*
     * Channel D mode selection
     * 0 : Channel used for digital input
     * 1 : Channel used for digital output
     */
    b_ArgArray[4] = 0;
            
    i_ReturnValue = ioctl (fd,CMD_APCI1710_InitTTLIODirection, b_ArgArray);

    /* Test the return value */
    switch (i_ReturnValue)
        {
        case 0:
        printf ("\nCMD_APCI1710_InitTTLIODirection OK\n");

        /* Test all channel*/
        for (b_SelectedPort = 0; b_SelectedPort < 3; b_SelectedPort ++)
            {
            /* Test all channel*/
            for (b_TTLChannel = 0; b_TTLChannel <= 7; b_TTLChannel ++) // 3
                {

                b_ArgArray[0] = b_ModuleNbr;
                b_ArgArray[1] = b_SelectedPort;
                b_ArgArray[2] = b_TTLChannel;

                i_ReturnValue = ioctl (fd,CMD_APCI1710_ReadTTLIOChannelValue, b_ArgArray);
                /* Test the return value */
                switch (i_ReturnValue)
                    {
                    case 0:
                    b_ChannelStatus = b_ArgArray[0];
                    printf ("TTL:module %d, port %d, Status of Input Channel %d  : is %d\n",b_ModuleNbr, b_SelectedPort, b_TTLChannel,b_ChannelStatus );
                    break;

                    case 1:
                    printf ("\nCMD_APCI1710_ReadTTLIOChannelValue error");
                    printf ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
                    break;

                    case 2:
                    printf ("\nCMD_APCI1710_ReadTTLIOChannelValue error");
                    printf ("\nError = %d. The module parameter is wrong", i_ReturnValue);
                    break;

                    case 3:
                    printf ("\nCMD_APCI1710_ReadTTLIOChannelValue errornDigital");
                    printf ("\nError = %d. The module is not a ttl I/O module", i_ReturnValue);
                    break;

                    case 4:
                    printf ("\nCMD_APCI1710_ReadTTLIOChannelValue error");
                    printf ("\nError = %d. The selected TTL input port is wrong", i_ReturnValue);
                    break;

                    case 5:
                    printf ("\nCMD_APCI1710_ReadTTLIOChannelValue error");
                    printf ("\nError = %d. The selected TTL digital input is wrong", i_ReturnValue);
                    break;

                    case 6:
                    printf ("\nCMD_APCI1710_ReadTTLIOChannelValue error");
                    printf ("\nError = %d. TTL I/O not initialised", i_ReturnValue);
                    break;

                    default:
                    printf ("\nCMD_APCI1710_ReadTTLIOChannelValue error");
                    printf ("\nError = %d.", i_ReturnValue);
                    perror("CMD_APCI1710_ReadTTLIOChannelValue");
                    break;
                    }

                }

        }
        break;

        case 1:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
        break;

        case 2:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d. The module parameter is wrong", i_ReturnValue);
        break;

        case 3:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d. The module is not a ttl I/O module", i_ReturnValue);
        break;

        case 4:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d. Function not available for this version", i_ReturnValue);
        break;

        case 5:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d. Port A mode selection is wrong", i_ReturnValue);
        break;

        case 6:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d. Port B mode selection is wrong", i_ReturnValue);
        break;

        case 7:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d. Port C mode selection is wrong", i_ReturnValue);
        break;

        case 8:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d. Port D mode selection is wrong", i_ReturnValue);
        break;

        default:
        printf ("\nCMD_APCI1710_InitTTLIODirection error");
        printf ("\nError = %d", i_ReturnValue);
        break;
        } // switch (i_ReturnValue)

    }
    
//--------------------------------------------------------------------------------


int main(int argc, char** argv)
{

    int * apci1710_card_fd;
    unsigned int apci1710_card_number = 0;
    {
        apci1710_card_number = apci1710_find_cards(&apci1710_card_fd);
        
        printf("total: %d cards\n",apci1710_card_number);
    }    
    
    {
        int i;
        for (i=0;i< apci1710_card_number; i++)
        {
            printf("\n+++++++++++++++++++++++++++++++++++++\nrunning test on device of minor number %d\n+++++++++++++++++++++++++++++++++++++\n\n\n",i);
            
            /* Compare logic sample */
            sample (apci1710_card_fd[i]);    
        }
    }

    

    return 0;
}
//--------------------------------------------------------------------------------
