/** @file sample_apci1710_inc_counter_with_input_filter.c
 
   This demonstrates how to use the incremental counter in user mode.
 
   @par CREATION  
   @author Krauth Julien
   @date   28.11.08
   
   @par VERSION
   @verbatim
   $LastChangedRevision:$
   $LastChangedDate:$
   @endverbatim   
   
   @par LICENCE
   @verbatim
    Copyright (C) 2009  ADDI-DATA GmbH for the source code of this module.
        
    ADDI-DATA GmbH
    Airpark Business Center
    Airport Boulevard B210
    77836 Rheinm�nster
    Germany
    Tel: +49(0)7229/1847-0
    Fax: +49(0)7229/1847-200
    http://www.addi-data-com
    info@addi-data.com
        
   This program is free software; you can redistribute it and/or modify it under 
   the terms of the GNU General Public License as published by the Free Software 
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
   or FITNESS FOR A PARTICULAR PURPOSE. 
   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with 
   this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   You shoud also find the complete GPL in the COPYING file 
   accompanying this source code.
   @endverbatim   
 */ 

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#include <apci1710.h>

#include "sample_apci1710_common.h"

//--------------------------------------------------------------------------------
/**
 * @brief Demonstrates how to use the incremental counter with input filter in user mode.
 */
int sample (int fd)
{
    uint8_t b_ModuleNbr = 0;
    int i_ReturnValue = 0;
    uint32_t ul_CounterValue = 0;
    uint8_t i = 0;
    uint8_t b_ArgArray[6];
        
        /* Initialise the incremental counter */
        b_ArgArray[0] = b_ModuleNbr;            // The module to use (0 to 3).
        b_ArgArray[1] = APCI1710_32BIT_COUNTER;    // Selection form counter range.
        b_ArgArray[2] = APCI1710_DIRECT_MODE;    // First counter operating mode.
        b_ArgArray[3] = APCI1710_HYSTERESIS_ON;    // First counter option.
        b_ArgArray[4] = APCI1710_DIRECT_MODE;    // Second counter operating mode.
        b_ArgArray[5] = APCI1710_HYSTERESIS_ON;    // Second counter option.
                            
        i_ReturnValue = ioctl (fd,CMD_APCI1710_InitCounter, b_ArgArray);

        /* Test the return value */
        switch (i_ReturnValue)
        {
            case 0:
            {
                printf ("\nCMD_APCI1710_InitCounter OK");
                
                /* Clear the counter */
                i_ReturnValue = ioctl (fd,CMD_APCI1710_ClearCounterValue, b_ModuleNbr);
    
                /* Test the return value */
                switch (i_ReturnValue)
                {
                    case 0:
                        printf ("\nCMD_APCI1710_ClearCounterValue OK");
                    break;
    
                    case 1:
                        printf ("\nCMD_APCI1710_ClearCounterValue error");
                        printf ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
                        return 0;                        
                    break;
    
                    case 2:
                        printf ("\nCMD_APCI1710_ClearCounterValue error");
                        printf ("\nError = %d. The selected module number parameter is wrong", i_ReturnValue);
                        return 0;                        
                    break;
    
                    case 3:
                        printf ("\nCMD_APCI1710_ClearCounterValue error");
                        printf ("\nError = %d. Counter not initialised", i_ReturnValue);
                        return 0;                        
                    break;
    
                    default:
                        printf ("\nCMD_APCI1710_ClearCounterValue error");
                        printf ("\nError = %d.", i_ReturnValue);
                        perror("\nioctl");
                        return 0;
                    break;
                }
    
                printf ("\n\n");

                /* Initialize the incremental counter input filter */
                b_ArgArray[0] = b_ModuleNbr;    // The module to use (0 to 3).
                b_ArgArray[1] = APCI1710_40MHZ;    // Clock selection.
                b_ArgArray[2] = 9;                // Filter from 500ns

                i_ReturnValue = ioctl (fd,CMD_APCI1710_SetInputFilter, b_ArgArray);

                /* Test the return value */
                switch (i_ReturnValue)
                {
                    case 0:
                        printf ("\nCMD_APCI1710_SetInputFilter OK");
                    break;

                    case 1:
                        printf ("\nCMD_APCI1710_SetInputFilter error");
                        printf ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
                        return 0;
                    break;

                    case 2:
                        printf ("\nCMD_APCI1710_SetInputFilter error");
                        printf ("\nError = %d. The selected module number parameter is wrong", i_ReturnValue);
                        return 0;
                    break;

                    case 3:
                        printf ("\nCMD_APCI1710_SetInputFilte rerror");
                        printf ("\nError = %d. Counter not initialized", i_ReturnValue);
                        return 0;
                    break;

                    case 4:
                        printf ("\nCMD_APCI1710_SetInputFilter error");
                        printf ("\nError = %d. The selected PCI input clock is wrong", i_ReturnValue);
                        return 0;
                    break;

                    case 5:
                        printf ("\nCMD_APCI1710_SetInputFilter error");
                        printf ("\nError = %d. The selected filter value is wrong", i_ReturnValue);
                        return 0;
                    break;

                    default:
                        printf ("\nCMD_APCI1710_SetInputFilter error");
                        printf ("\nError = %d.", i_ReturnValue);
                        perror("\nioctl");
                        return 0;
                    break;
                }

                printf ("\n\n");
    
                do
                {
                    /* Read the 32-Bit counter */
                    ul_CounterValue = b_ModuleNbr; /* Initialize the module number (0 to 3) */
                    
                    i_ReturnValue = ioctl (fd,CMD_APCI1710_Read32BitCounterValue, &ul_CounterValue);
    
                    /* Test the return value */
                    switch (i_ReturnValue)
                    {
                        case 0:
                        break;
    
                        case 1:
                            printf ("\nCMD_Read32BitCounterValue for the first counter error");
                            printf ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
                            return 0;                            
                        break;
    
                        case 2:
                            printf ("\nCMD_Read32BitCounterValue for the first counter error");
                            printf ("\nError = %d. No counter module found", i_ReturnValue);
                            return 0;                            
                        break;
    
                        case 3:
                            printf ("\nCMD_Read32BitCounterValue for the first counter error");
                            printf ("\nError = %d. Counter not initialised", i_ReturnValue);
                            return 0;
                        break;
    
                        default:
                            printf ("\nCMD_Read32BitCounterValue for the first counter error");
                            printf ("\nError = %d.", i_ReturnValue);
                            perror("\nioctl");
                            return 0;                            
                        break;
                    }
    
                    printf ("\nCounter value from module %d  = %u", b_ModuleNbr, ul_CounterValue);
                        
                    sleep (1);
                }
                while (i++ < 100);                       
            }

            /* Release the incremental counter input filter */
            b_ArgArray[0] = b_ModuleNbr;    // The module to use (0 to 3).
            b_ArgArray[1] = APCI1710_40MHZ;    // Clock selection.
            b_ArgArray[2] = 0;                // Filter from 800ns

            i_ReturnValue = ioctl (fd,CMD_APCI1710_SetInputFilter, b_ArgArray);

            /* Test the return value */
            switch (i_ReturnValue)
            {
                case 0:
                    printf ("\nCMD_APCI1710_SetInputFilter OK");
                break;

                case 1:
                    printf ("\nCMD_APCI1710_SetInputFilter error");
                    printf ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
                    return 0;
                break;

                case 2:
                    printf ("\nCMD_APCI1710_SetInputFilter error");
                    printf ("\nError = %d. The selected module number parameter is wrong", i_ReturnValue);
                    return 0;
                break;

                case 3:
                    printf ("\nCMD_APCI1710_SetInputFilte rerror");
                    printf ("\nError = %d. Counter not initialized", i_ReturnValue);
                    return 0;
                break;

                case 4:
                    printf ("\nCMD_APCI1710_SetInputFilter error");
                    printf ("\nError = %d. The selected PCI input clock is wrong", i_ReturnValue);
                    return 0;
                break;

                case 5:
                    printf ("\nCMD_APCI1710_SetInputFilter error");
                    printf ("\nError = %d. The selected filter value is wrong", i_ReturnValue);
                    return 0;
                break;

                default:
                    printf ("\nCMD_APCI1710_SetInputFilter error");
                    printf ("\nError = %d.", i_ReturnValue);
                    perror("\nioctl");
                    return 0;
                break;
            }

            break;

            case 1:
                printf ("\nCMD_APCI1710_InitCounter error");
                printf ("\nError = %d. The handle parameter of the board is wrong", i_ReturnValue);
            break;

            case 2:
                printf ("\nCMD_APCI1710_InitCounter error");
                printf ("\nError = %d. The module is not a counter module", i_ReturnValue);
            break;

            case 3:
                printf ("\nCMD_APCI1710_InitCounter error");
                printf ("\nError = %d. The selected counter range is wrong", i_ReturnValue);
            break;

            case 4:
                printf ("\nCMD_APCI1710_InitCounter error");
                printf ("\nError = %d. The selected first counter operating mode is wrong", i_ReturnValue);
            break;

            case 5:
                printf ("\nCMD_APCI1710_InitCounter error");
                printf ("\nError = %d. The selected first counter operating option is wrong", i_ReturnValue);
            break;

            case 6:
                printf ("\nCMD_APCI1710_InitCounter error");
                printf ("\nError = %d. The selected second counter operating mode is wrong", i_ReturnValue);
            break;

            case 7:
                printf ("\nCMD_APCI1710_InitCounter error");
                printf ("\nError = %d. The selected second counter operating option is wrong", i_ReturnValue);
            break;

            default:
                printf ("\nCMD_APCI1710_InitCounter error");
                printf ("\nError = %d", i_ReturnValue);
                perror("\nioctl");            
            break;
            }

            printf ("\nProgram concluded.");
    return 0;
}

//--------------------------------------------------------------------------------

int main(int argc, char** argv)
{

    int * apci1710_card_fd;
    unsigned int apci1710_card_number = 0;

        apci1710_card_number = apci1710_find_cards(&apci1710_card_fd);
        
        printf("total: %d cards\n",apci1710_card_number);
        
        /* Use the incremental counter on the first APCI-1710 */
        sample (apci1710_card_fd[0]);    

    return 0;
}

//--------------------------------------------------------------------------------
