/** @file ReadDigitalInputs.c
 *
 *  @authors S. Beuque
 *  @date    Creation: 06.10.2014
 *
 *  @par DESCRIPTION
 *  This sample reads digital inputs 
 *
 *  @par LICENCE
 *  @verbatim
 *  Copyright (C) 2009 - 2014 ADDI-DATA GmbH
 *
 *  ADDI-DATA GmbH
 *  Airpark Business Center
 *  Airport Boulevard B210
 *  77836 Rheinmnster
 *  Germany
 *  Tel: +49(0)7229/1847-0    |  Fax: +49(0)7229/1847-200
 *  http://www.addi-data-com  |  info@addi-data.com
 *  @endverbatim
 **/

#include "StdAfx.h"


int _tmain(int argc, _TCHAR *argv[])
{
	INT    i_ReturnValue = 0;
	HANDLE h_BoardHandle = NULL;
	DWORD  numberOfChannelsToRead = 0;
	BYTE   value = 0;

	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);

	printf("/****************************************************************************\\\n"
	       "|*                         ReadDigitalInputs sample                         *|\n"
	       "|****************************************************************************|\n"
	       "|* This sample reads digital inputs                                         *|\n"
	       "\\****************************************************************************/\n\n");


	i_ReturnValue = i_Utils_OpenBoard(&h_BoardHandle);
	if (i_ReturnValue != 0)
	{
		fprintf(stderr, "i_Utils_OpenBoard failed: %d\n", i_ReturnValue);
		_getch();
		return i_ReturnValue;
	}

	numberOfChannelsToRead = (DWORD) ll_Utils_ReadInteger(0, 1, "Select how many channel(s) you want to read\n\t0: 1 channel\n\t1: all channels");
	if (numberOfChannelsToRead == 0)
	{
		BYTE channel = (BYTE) ll_Utils_ReadInteger(0, 3, "Select the channel to read");
		i_ReturnValue = i_PCI3300_Read1DigitalInput(h_BoardHandle, channel, &value);
		if (i_ReturnValue != 0)
			printf("i_PCI3300_Read1DigitalInput error %d\n", i_ReturnValue);
		else
			printf("Channel value = %x", value & 0x1);
	}
	else
	{
		i_ReturnValue = i_PCI3300_Read4DigitalInputs(h_BoardHandle, &value);
		if (i_ReturnValue != 0)
			printf("i_PCI3300_Read4DigitalInputs error %d\n", i_ReturnValue);
		else
			printf("Channel port value = %x\n", value);
	}

	i_ReturnValue = i_PCI3300_CloseBoard(h_BoardHandle);
	if (i_ReturnValue != 0)
	{
		fprintf(stderr, "i_PCI3300_CloseBoard failed: %d\n", i_ReturnValue);
		_getch();
		return i_ReturnValue;
	}
	printf("i_PCI3300_CloseBoard OK\n");

	printf("\nPress any key to exit the sample...\n");
	_getch();
	return i_ReturnValue;
}
