/** @file SetDigitalOutputs.c
 *
 *  @authors S. Beuque
 *  @date    Creation: 09.10.2014
 *
 *  @par DESCRIPTION
 *  This sample set digital outputs 
 *
 *  @par LICENCE
 *  @verbatim
 *  Copyright (C) 2009 - 2014 ADDI-DATA GmbH
 *
 *  ADDI-DATA GmbH
 *  Airpark Business Center
 *  Airport Boulevard B210
 *  77836 Rheinmnster
 *  Germany
 *  Tel: +49(0)7229/1847-0    |  Fax: +49(0)7229/1847-200
 *  http://www.addi-data-com  |  info@addi-data.com
 *  @endverbatim
 **/

#include "StdAfx.h"


int _tmain(int argc, _TCHAR *argv[])
{
	INT    i_ReturnValue = 0;
	HANDLE h_BoardHandle = NULL;
	DWORD  dw_DOutputMemory = 0;
	BYTE   b_OutputStatus = 0;
	DWORD  numberOfChannelsToSet = 0;
	DWORD  choice = 1;
	
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);

	printf("/****************************************************************************\\\n"
	       "|*                         SetDigitalOutputs sample                         *|\n"
	       "|****************************************************************************|\n"
	       "|* This sample set digital outputs                                          *|\n"
	       "\\****************************************************************************/\n\n");

	
	i_ReturnValue = i_Utils_OpenBoard(&h_BoardHandle);
	if (i_ReturnValue != 0)
	{
		fprintf(stderr, "i_Utils_OpenBoard failed: %d\n", i_ReturnValue);
		_getch();
		return i_ReturnValue;
	}

	dw_DOutputMemory = (DWORD)ll_Utils_ReadInteger(0, 1, "Do you want to use output memory ? (0: No, 1: Yes)");
	if (dw_DOutputMemory == 1)
	{
		i_ReturnValue = i_PCI3300_SetDigitalOutputMemoryOn(h_BoardHandle);
		if (i_ReturnValue != 0)
		{
			printf("i_PCI3300_SetDigitalOutputMemoryOn Error : %d\n", i_ReturnValue);
			goto function_end;
		}
	}
	else
	{
		i_ReturnValue = i_PCI3300_SetDigitalOutputMemoryOff(h_BoardHandle);
		if (i_ReturnValue != 0)
		{
			printf("i_PCI3300_SetDigitalOutputMemoryOff error %d\n", i_ReturnValue);
			goto function_end;
		}
	}
	do
	{
		BYTE b_Channel     = 0;
		BYTE b_ChannelMask = 0;

		if (dw_DOutputMemory != 0)
			numberOfChannelsToSet = (DWORD)ll_Utils_ReadInteger(0, 3, "How many channels do you want to set \n\t0 : set 1 channel ON\n\t1: set 1 channel OFF\n\t2: set all channels ON\n\t3: set all channel OFF");
		else
			numberOfChannelsToSet = (DWORD)ll_Utils_ReadInteger(0, 1, "How many channels do you want to set \n\t0: set 1 channel ON\n\t1: set all channels ON\n\t") * 2;

		switch(numberOfChannelsToSet)
		{
			case 0:
				b_Channel = (BYTE)ll_Utils_ReadInteger(0, 2, "Which digital output do you want to set ON ? (0 to 2)");
				i_ReturnValue = i_PCI3300_Set1DigitalOutputOn(h_BoardHandle, b_Channel);
				if (i_ReturnValue != 0)
				{
					printf("i_PCI3300_Set1DigitalOutputOn error %d\n", i_ReturnValue);
					goto function_end;
				}
				break;
			case 1:
				b_Channel = (BYTE)ll_Utils_ReadInteger(0, 2, "Which digital output do you want to set OFF ? (0 to 2)");
				i_ReturnValue = i_PCI3300_Set1DigitalOutputOff(h_BoardHandle, b_Channel);
				if (i_ReturnValue != 0)
				{
					printf("i_PCI3300_Set1DigitalOutputOff error %d\n", i_ReturnValue);
					goto function_end;
				}
				break;
			case 2:
				b_ChannelMask = (BYTE)ll_Utils_ReadInteger(0, 0x7, "Give the channel mask (0x0 to 0x7) to set corresponding digital outputs ON?");
				i_ReturnValue = i_PCI3300_Set3DigitalOutputsOn(h_BoardHandle, b_ChannelMask);
				if (i_ReturnValue != 0)
				{
					printf("i_PCI3300_Set3DigitalOutputOn error %d\n", i_ReturnValue);
					goto function_end;
				}
				break;
			case 3:
				b_ChannelMask = (BYTE)ll_Utils_ReadInteger(0, 0x7, "Give the channel mask (0 to 0x7) to set corresponding digital outputs OFF?");
				i_ReturnValue = i_PCI3300_Set3DigitalOutputsOff(h_BoardHandle, b_ChannelMask);
				if (i_ReturnValue != 0)
				{
					printf("i_PCI3300_Set3DigitalOutputOff error %d\n", i_ReturnValue);
					goto function_end;
				}
				break;
		}

		if (numberOfChannelsToSet < 2)
			i_ReturnValue = i_PCI3300_Get1DigitalOutputStatus(h_BoardHandle, b_Channel, &b_OutputStatus);
		else
			i_ReturnValue = i_PCI3300_Get3DigitalOutputsStatus(h_BoardHandle, &b_OutputStatus);

		if (i_ReturnValue != 0)
		{
			printf("i_PCI3300_Get%sDigitalOutputStatus error %d\n", (numberOfChannelsToSet < 2) ? "1" : "3", i_ReturnValue);
			goto function_end;
		}

		if (numberOfChannelsToSet > 1)
			printf("Digital output status = %x\n", b_OutputStatus);
		else
			printf("Digital output status for channel %d = %x\n", b_Channel, b_OutputStatus);

		choice = (DWORD)ll_Utils_ReadInteger(0, 1, "Do you want to set other channels ? (0:No, 1:Yes)");

	}while(choice != 0);
function_end:

	i_ReturnValue = i_PCI3300_CloseBoard(h_BoardHandle);
	if (i_ReturnValue != 0)
	{
		fprintf(stderr, "i_PCI3300_CloseBoard failed: %d\n", i_ReturnValue);
		_getch();
		return i_ReturnValue;
	}
	printf("i_PCI3300_CloseBoard OK\n");


	printf("\nPress any key to exit the sample...\n");
	_getch();
	return i_ReturnValue;
}
