/** @file PCI3300_LabView.h
 *
 *  @authors L.ElBakali, S. Beuque, J. Krauth, L. Sartory
 *  @date    Creation: 17.01.2013
 *  @date    $LastChangedDate$
 *  @version $LastChangedRevision$
 *
 *  @par DESCRIPTION
 *  PCI3300 LabView header file 
 *
 *  @par LICENCE
 *  @verbatim
 *  Copyright (C) 2009 - 2013 ADDI-DATA GmbH
 *
 *  ADDI-DATA GmbH
 *  Airpark Business Center
 *  Airport Boulevard B210
 *  77836 Rheinmnster
 *  Germany
 *  Tel: +49(0)7229/1847-0    |  Fax: +49(0)7229/1847-200
 *  http://www.addi-data-com  |  info@addi-data.com
 *  @endverbatim
 **/

//General function
short int __stdcall i_PCI3300_GetNumberOfBoards(unsigned __int8 *NbrOfBoards);
short int __stdcall i_PCI3300_GetBoardInformation(unsigned __int8 BoardIndex, unsigned long int IdentifierStringSize, char *Identifier, unsigned long int *UINumber, unsigned long int *DeviceNumber, unsigned long int *BusNumber, unsigned long int *BaseAddress0, unsigned long int *BaseAddress1, unsigned long int *BaseAddress2, unsigned long int *BaseAddress3, unsigned __int8 *Interrupt);
short int __stdcall i_PCI3300_GetNumberOfModules(unsigned long int DeviceHandle, unsigned long int *NumberOfModules );  
short int __stdcall i_PCI3300_OpenBoardViaIndex(unsigned __int8 BoardIndex, unsigned long int *DeviceHandle);
short int __stdcall i_PCI3300_OpenBoardViaIdentifier(char *Identifier, unsigned long int *DeviceHandle);
short int __stdcall i_PCI3300_CloseBoard(unsigned long int DeviceHandle);
short int __stdcall i_PCI3300_GetDLLVersion(unsigned long int *Version);
short int __stdcall i_PCI3300_GetDeviceDriverVersion(unsigned long int DeviceHandle, unsigned long int *Version);

short int __stdcall i_PCI3300_SetLabViewInterrupt(unsigned long int DeviceHandle, LVUserEventRef *LabViewEventRef);
short int __stdcall i_PCI3300_ResetLabViewInterrupt(unsigned long int DeviceHandle);

//Digital inputs functionnality
short int __stdcall i_PCI3300_Read1DigitalInput(unsigned long int DeviceHandle, unsigned __int8 Channel, unsigned __int8 *Value);
short int __stdcall i_PCI3300_Read4DigitalInputs(unsigned long int DeviceHandle, unsigned __int8 *Value);

//Digital Outputs functionnality
short int __stdcall i_PCI3300_Set1DigitalOutputOn(unsigned long int DeviceHandle, unsigned __int8 Channel);
short int __stdcall i_PCI3300_Set1DigitalOutputOff(unsigned long int DeviceHandle, unsigned __int8 Channel);
short int __stdcall i_PCI3300_Set3DigitalOutputsOn(unsigned long int DeviceHandle, unsigned __int8 Mask);
short int __stdcall i_PCI3300_Set3DigitalOutputsOff(unsigned long int DeviceHandle, unsigned __int8 Mask);
short int __stdcall i_PCI3300_SetDigitalOutputMemoryOn(unsigned long int DeviceHandle); 
short int __stdcall i_PCI3300_SetDigitalOutputMemoryOff(unsigned long int DeviceHandle);
short int __stdcall i_PCI3300_Get1DigitalOutputStatus(unsigned long int DeviceHandle, unsigned __int8 Channel, unsigned __int8 *OutputsStatus); 
short int __stdcall i_PCI3300_Get4DigitalOutputsStatus(unsigned long int DeviceHandle, unsigned __int8 *OutputsStatus);

// pressure function
short int __stdcall i_PCI3300_Read1PressureChannel(unsigned long int DeviceHandle, unsigned __int8 ModuleIndex, unsigned __int8 ChannelIndex, unsigned __int8 Gain, unsigned long int DataFormat, unsigned short int SensorOffset, unsigned short int SensorSensibility, unsigned long int ConvertingTime, unsigned __int8 b_Option, unsigned short int *ChannelValue );
short int __stdcall i_PCI3300_InitAndStartScanModuleAcquisition(unsigned long int DeviceHandle, unsigned __int8 ModuleIndex, unsigned long int ConvertingTime, unsigned __int8 DelayMode, unsigned long int DelayTime, unsigned long int DelayUnit, unsigned __int8 AcquisitionMode, unsigned __int8 ExtTriggerMode);
short int __stdcall i_PCI3300_GetModuleAcquisitionStatus  (unsigned long int DeviceHandle, unsigned __int8 ModuleIndex, unsigned long int *Status); 
short int __stdcall i_PCI3300_ConvertAnalogToPressure   (unsigned short int AnalogValue,  unsigned short int SensorOffset ,  unsigned short int SensorSensibility,  unsigned short int *PressureValue); 
short int __stdcall i_PCI3300_StopScanModuleAcquisition (unsigned long int DeviceHandle, unsigned __int8 ModuleIndex); 



