/** @file define.h
 *
 *  @authors S. Beuque
 *  @date    Creation: 22.10.2014
 *
 *  @par DESCRIPTION
 *  Generic types definition 
 *
 *  @par LICENCE
 *  @verbatim
 *  Copyright (C) 2009 - 2014 ADDI-DATA GmbH
 *
 *  ADDI-DATA GmbH
 *  Airpark Business Center
 *  Airport Boulevard B210
 *  77836 Rheinmnster
 *  Germany
 *  Tel: +49(0)7229/1847-0    |  Fax: +49(0)7229/1847-200
 *  http://www.addi-data-com  |  info@addi-data.com
 *  @endverbatim
 **/

#ifndef __PCI3300__
	#define __PCI3300__
	#ifndef __COMPILER__

		/*********************************************************/
		/* DEFINE the type for the compilation of user's program */
		/*********************************************************/

		#define  CHAR       __int8
		#define  BYTE       unsigned __int8
		#define  INT        __int16
		#define  WORD       unsigned __int16
		#define  LONG       __int32
		#define  DWORD      unsigned __int32
		#define  LONGLONG   __int64
		#define  QWORD      unsigned __int64
		#define  DOUBLE     double
		#define  VOID       void

		#define  PCHAR      CHAR *
		#define  PBYTE      BYTE *
		#define  PINT       INT *
		#define  PWORD      WORD *
		#define  PLONG      LONG *
		#define  PDWORD     DWORD *
		#define  PLONGLONG  LONGLONG *
		#define  PQWORD     QWORD *
		#define  PDOUBLE    DOUBLE *
		#define  PVOID      VOID *

		/* Define the type for the parameter of the function */
		#define  CHAR_      CHAR
		#define  BYTE_      BYTE
		#define  INT_       INT
		#define  WORD_      WORD
		#define  LONG_      LONG
		#define  DWORD_     DWORD
		#define  LONGLONG_  LONGLONG
		#define  QWORD_     DWORD
		#define  DOUBLE_    DOUBLE
		#define  VOID_      VOID

		#define  PCHAR_     PCHAR
		#define  PBYTE_     PBYTE
		#define  PINT_      PINT
		#define  PWORD_     PWORD
		#define  PLONG_     PLONG
		#define  PDWORD_    PDWORD
		#define  PLONGLONG_ PLONGLONG
		#define  PQWORD_    PQWORD
		#define  PDOUBLE_   PDOUBLE
		#define  PVOID_     PVOID

		/* Define the type for the return of the function */
		#ifdef _BORLANDC_
			#ifdef __cplusplus
				#define  _CHAR_      extern "C" _import CHAR      far _stdcall
				#define  _BYTE_      extern "C" _import BYTE      far _stdcall
				#define  _INT_       extern "C" _import INT       far _stdcall
				#define  _WORD_      extern "C" _import WORD      far _stdcall
				#define  _LONG_      extern "C" _import LONG      far _stdcall
				#define  _DWORD_     extern "C" _import DWORD     far _stdcall
				#define  _LONGLONG_  extern "C" _import LONGLONG  far _stdcall
				#define  _QWORD_     extern "C" _import QWORD     far _stdcall
				#define  _DOUBLE_    extern "C" _import DOUBLE    far _stdcall
				#define  _VOID_      extern "C" _import VOID      far _stdcall

				#define  _PCHAR_     extern "C" _import PCHAR     far _stdcall
				#define  _PBYTE_     extern "C" _import PBYTE     far _stdcall
				#define  _PINT_      extern "C" _import PINT      far _stdcall
				#define  _PWORD_     extern "C" _import PWORD     far _stdcall
				#define  _PLONG_     extern "C" _import PLONG     far _stdcall
				#define  _PDWORD_    extern "C" _import PDWORD    far _stdcall
				#define  _PLONGLONG_ extern "C" _import PLONGLONG far _stdcall
				#define  _PQWORD_    extern "C" _import PQWORD    far _stdcall
				#define  _PDOUBLE_   extern "C" _import PDOUBLE   far _stdcall
				#define  _PVOID_     extern "C" _import PVOID     far _stdcall
			#else
				#define  _CHAR_      _import CHAR      far _stdcall
				#define  _BYTE_      _import BYTE      far _stdcall
				#define  _INT_       _import INT       far _stdcall
				#define  _WORD_      _import WORD      far _stdcall
				#define  _LONG_      _import LONG      far _stdcall
				#define  _DWORD_     _import DWORD     far _stdcall
				#define  _LONGLONG_  _import LONGLONG  far _stdcall
				#define  _QWORD_     _import QWORD     far _stdcall
				#define  _DOUBLE_    _import DOUBLE    far _stdcall
				#define  _VOID_      _import VOID      far _stdcall

				#define  _PCHAR_     _import PCHAR     far _stdcall
				#define  _PBYTE_     _import PBYTE     far _stdcall
				#define  _PINT_      _import PINT      far _stdcall
				#define  _PWORD_     _import PWORD     far _stdcall
				#define  _PLONG_     _import PLONG     far _stdcall
				#define  _PDWORD_    _import PDWORD    far _stdcall
				#define  _PLONGLONG_ _import PLONGLONG far _stdcall
				#define  _PQWORD_    _import PQWORD    far _stdcall
				#define  _PDOUBLE_   _import PDOUBLE   far _stdcall
				#define  _PVOID_     _import PVOID     far _stdcall
			#endif
		#else
			#define  _CHAR_      CHAR      far _stdcall
			#define  _BYTE_      BYTE      far _stdcall
			#define  _INT_       INT       far _stdcall
			#define  _WORD_      WORD      far _stdcall
			#define  _LONG_      LONG      far _stdcall
			#define  _DWORD_     DWORD     far _stdcall
			#define  _LONGLONG_  LONGLONG  far _stdcall
			#define  _QWORD_     QWORD     far _stdcall
			#define  _DOUBLE_    DOUBLE    far _stdcall
			#ifdef __cplusplus
				#define  _VOID_            far _stdcall
			#else
				#define  _VOID_      VOID  far _stdcall
			#endif

			#define  _PCHAR_     PCHAR     far _stdcall
			#define  _PBYTE_     PBYTE     far _stdcall
			#define  _PINT_      PINT      far _stdcall
			#define  _PWORD_     PWORD     far _stdcall
			#define  _PLONG_     PLONG     far _stdcall
			#define  _PDWORD_    PDWORD    far _stdcall
			#define  _PLONGLONG_ PLONGLONG far _stdcall
			#define  _PQWORD_    PQWORD    far _stdcall
			#define  _PDOUBLE_   PDOUBLE   far _stdcall
			#define  _PVOID_     PVOID     far _stdcall
		#endif
	#endif
#endif
