/** @file PressureScanInterrupt.c
 *
 *  @authors S. Beuque
 *  @date    Creation: 06.10.2014
 *
 *  @par DESCRIPTION
 *  This sample shows how to use scan interrupt 
 *
 *  @par LICENCE
 *  @verbatim
 *  Copyright (C) 2009 - 2014 ADDI-DATA GmbH
 *
 *  ADDI-DATA GmbH
 *  Airpark Business Center
 *  Airport Boulevard B210
 *  77836 Rheinmnster
 *  Germany
 *  Tel: +49(0)7229/1847-0    |  Fax: +49(0)7229/1847-200
 *  http://www.addi-data-com  |  info@addi-data.com
 *  @endverbatim
 **/

#include "StdAfx.h"

int _tmain(int argc, _TCHAR *argv[])
{
	INT    i_ReturnValue = 0;
	HANDLE h_BoardHandle = NULL;
	BYTE   b_ModuleIndex         = 0;
	DWORD  dw_ConvertingTime     = 0;
	DWORD  dw_NumberOfModules    = 0;
	BYTE   b_DelayMode           = 0;
	WORD   w_DelayTime           = 0;
	WORD   w_DelayUnit           = 0;
	BYTE   b_AcquisitionMode     = 0;
	BYTE   b_ExtTriggerMode      = 0;
	DWORD  i                     = 0;

	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);

	printf("/****************************************************************************\\\n"
	       "|*                       PressureScanInterrupt sample                       *|\n"
	       "|****************************************************************************|\n"
	       "|* This sample shows how to use scan interrupt                              *|\n"
	       "\\****************************************************************************/\n\n");

	i_ReturnValue = i_Utils_OpenBoard(&h_BoardHandle);
	if (i_ReturnValue != 0)
	{
		fprintf(stderr, "i_Utils_OpenBoard failed: %d\n", i_ReturnValue);
		_getch();
		return i_ReturnValue;
	}

	i_ReturnValue = i_PCI3300_GetNumberOfModules(h_BoardHandle, &dw_NumberOfModules);
	if (i_ReturnValue != 0)
	{
		fprintf(stderr, "i_PCI3300_GetNumberOfModules failed: %d\n", i_ReturnValue);
		goto sample_end;
	}
	printf("i_PCI3300_GetNumberOfModules OK\n");

	b_ModuleIndex  = (BYTE)ll_Utils_ReadInteger(0, dw_NumberOfModules - 1, "On which module do you want to start SCAN acquisition (0 to %d)", dw_NumberOfModules - 1);

	dw_ConvertingTime = (DWORD)ll_Utils_ReadInteger(20, 255, "Enter the converting time in Hz (20 Hz, 40 Hz, 80 Hz, 160 Hz)");

	b_DelayMode = (BYTE)ll_Utils_ReadInteger(0, 1, "Do you want to use the delay (0: no, 1: yes)");
	if (b_DelayMode != 0)
	{
		w_DelayUnit = (WORD)ll_Utils_ReadInteger(0, 1, "Enter the delay unit (0: ms, 1: s)");
		w_DelayTime = (WORD)ll_Utils_ReadInteger(0, 1023, "Enter the delay time (0 to 1023)");
	}

	b_AcquisitionMode = (BYTE)ll_Utils_ReadInteger(0, 1, "Select acquisition mode\n\t0: Single scan\n\t1: Continuous scan");
	
	_convertToPressure = (BYTE)ll_Utils_ReadInteger(0, 1, "Do you want to convert the analog value (mV) to pressure value (0: No, 1: Yes)\n");

	b_ExtTriggerMode = (BYTE)ll_Utils_ReadInteger(0, 3, "Do you want to use a trigger (starts all acquisition)\n\t0: Trigger disabled"
		"\n\t1: Trigger on rising edge"
		"\n\t2: Trigger on falling edge"
		"\n\t3: Trigger on both edges");
	
	if (_convertToPressure != 0)
	{
		memset(_sensorSensibility, 0, sizeof(_sensorSensibility));
		memset(_sensorOffset, 0, sizeof(_sensorOffset));

		for (i = 0; i < 2; i++)
		{
			printf("Enter the sensor offset voltage in mV for channel %d: \n", i);
			scanf_s("%lf", &_sensorOffset[i]);

			do
			{
				printf("Enter the sensor sensibility in mV/V/unit for channel %d: \n", i);
				scanf_s("%lf", &_sensorSensibility[i]);
			}while(_sensorSensibility[i] == 0.0);
		}
	}

	i_ReturnValue = i_PCI3300_SetBoardIntRoutine(h_BoardHandle, &v_Utils_InterruptRoutine);
	if (i_ReturnValue != 0)
	{		
		printf("i_PCI3300_SetBoardIntRoutine error %d\n", i_ReturnValue);
		goto sample_end;
	}
	printf("i_PCI3300_SetBoardIntRoutine OK\n");
	
	i_ReturnValue = i_PCI3300_InitAndStartScanModuleAcquisition(h_BoardHandle,
		b_ModuleIndex,
		dw_ConvertingTime,
		b_DelayMode,
		w_DelayTime,
		w_DelayUnit,
		b_AcquisitionMode,
		b_ExtTriggerMode);
	if (i_ReturnValue != 0)
	{
		printf("i_PCI3300_InitAndStartScanModuleAcquisition error %d\n", i_ReturnValue);
		goto sample_end;
	}
	printf("i_PCI3300_InitAndStartScanModuleAcquisition OK\n");

	_getch();

sample_end:
	i_ReturnValue = i_PCI3300_StopScanModuleAcquisition(h_BoardHandle, b_ModuleIndex);
	if (i_ReturnValue != 0)
		printf("i_PCI3300_StopScanModuleAcquisition error %d\n", i_ReturnValue);
	
	printf("i_PCI3300_StopScanModuleAcquisition OK\n");

	i_ReturnValue = i_PCI3300_ResetBoardIntRoutine(h_BoardHandle);
	if (i_ReturnValue != 0)
		printf("i_PCI3300_ResetBoardIntRoutine error %d\n", i_ReturnValue);

	printf("i_PCI3300_ResetBoardIntRoutine OK\n");

	i_ReturnValue = i_PCI3300_CloseBoard(h_BoardHandle);
	if (i_ReturnValue != 0)
	{
		fprintf(stderr, "i_PCI3300_CloseBoard failed: %d\n", i_ReturnValue);
		_getch();
		return i_ReturnValue;
	}
	printf("i_PCI3300_CloseBoard OK\n");

	printf("\nPress any key to exit the sample...\n");
	_getch();
	return i_ReturnValue;
}
