/** @file DllImport.cs
 *
 *  @authors S. Beuque
 *  @date    Creation: 06.10.2014
 *  @date    $LastChangedDate$
 *  @version $LastChangedRevision$
 *
 *  @par DESCRIPTION
 *  PCI3300.dll imports 
 *
 *  @par LICENCE
 *  @verbatim
 *  Copyright (C) 2009 - 2014 ADDI-DATA GmbH
 *
 *  ADDI-DATA GmbH
 *  Airpark Business Center
 *  Airport Boulevard B210
 *  77836 Rheinmnster
 *  Germany
 *  Tel: +49(0)7229/1847-0    |  Fax: +49(0)7229/1847-200
 *  http://www.addi-data-com  |  info@addi-data.com
 *  @endverbatim
 **/

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace PCI3300_NET
{
    /// <summary>
    /// Contains the prototypes of the DLL functions
    /// </summary>
    public class DllImport
    {
        /// <summary>
        /// Definition of the user interruption function prototype
        /// </summary>
        [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
        public delegate void InterruptFunctionEventHandler(IntPtr handle, Byte overflow, UInt32 source, UInt32 mask, IntPtr args, UInt32 argsSize);

#region "Generic"
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_GetNumberOfBoards(out Byte pb_NbrOfBoards);
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_GetBoardInformation(Byte b_BoardIndex, UInt32 dw_IdentifierStringSize, Byte[] pc_Identifier, out UInt32 pdw_UINumber, out UInt32 pdw_DeviceNumber, out UInt32 pdw_BusNumber, out UInt32 pdw_BaseAddress0, out UInt32 pdw_BaseAddress1, out UInt32 pdw_BaseAddress2, out UInt32 pdw_BaseAddress3, out Byte pb_Interrupt);
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_OpenBoardViaIndex(Byte b_BoardIndex, out IntPtr ph_DeviceHandle);
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_OpenBoardViaIdentifier(Byte[] pc_Identifier, out IntPtr ph_DeviceHandle);
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_CloseBoard(IntPtr h_DeviceHandle);
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_GetDLLVersion(out Int32 pdw_Version);
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_GetDeviceDriverVersion(IntPtr h_DeviceHandle, out Int32 pdw_Version);
		[DllImport("PCI3300.dll")]
		public static extern IntPtr pc_PCI3300_GetLastError(IntPtr h_DeviceHandle);
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_SetBoardIntRoutine(IntPtr h_DeviceHandle, [MarshalAs(UnmanagedType.FunctionPtr)] InterruptFunctionEventHandler interruptFunction);
		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_ResetBoardIntRoutine(IntPtr h_DeviceHandle);
#endregion

#region "PCI3300"

#endregion
#region "Pressure"

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_InitPressureChannel(IntPtr deviceHandle, Byte channel);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Read1PressureChannel(IntPtr deviceHandle, Byte moduleIndex, Byte channelMask, Byte gain, UInt32 dataFormat, double offsetVoltage, double sensorSensibility, UInt32 convertingTime, Byte interrupt, out double channelValue);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_InitScanModuleAcquisitionSensor(IntPtr deviceHandle, Byte moduleIndex);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_InitAndStartScanModuleAcquisition(IntPtr deviceHandle, Byte moduleIndex, UInt32 convertingTime, Byte delayMode, UInt16 delayTime, UInt16 delayUnit, Byte acquisitionMode, Byte extTriggerMode);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_StopScanModuleAcquisition(IntPtr deviceHandle, Byte moduleIndex);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_GetModuleAcquisitionStatus(IntPtr deviceHandle, Byte moduleIndex, out UInt32 status);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_ConvertAnalogToPressure(double analogValue, double sensorOffset, double sensorSensibility, out double pressureValue);

#endregion
#region "DInputs"

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Read1DigitalInput(IntPtr deviceHandle, Byte channel, out Byte value);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Read4DigitalInputs(IntPtr deviceHandle, out Byte value);

#endregion
#region "DOutputs"

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Set1DigitalOutputOn(IntPtr deviceHandle, Byte channel);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Set1DigitalOutputOff(IntPtr deviceHandle, Byte channel);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Set3DigitalOutputsOn(IntPtr deviceHandle, Byte mask);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Set3DigitalOutputsOff(IntPtr deviceHandle, Byte mask);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_SetDigitalOutputMemoryOn(IntPtr deviceHandle);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_SetDigitalOutputMemoryOff(IntPtr deviceHandle);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Get1DigitalOutputStatus(IntPtr deviceHandle, Byte channel, out Byte outputsStatus);

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_Get3DigitalOutputsStatus(IntPtr deviceHandle, out Byte outputsStatus);

#endregion
#region "board"

		[DllImport("PCI3300.dll")]
		public static extern short i_PCI3300_GetNumberOfModules(IntPtr deviceHandle, out UInt32 numberOfModules);

#endregion
#region "Misc"
#endregion
    }
}
