/** @file EndOfSequenceEventArgs.cs
 *
 *  @authors S. Beuque
 *  @date    Creation: 06.10.2014
 *  @date    $LastChangedDate$
 *  @version $LastChangedRevision$
 *
 *  @par DESCRIPTION
 *  EndOfSequence event arguments definition 
 *
 *  @par LICENCE
 *  @verbatim
 *  Copyright (C) 2009 - 2014 ADDI-DATA GmbH
 *
 *  ADDI-DATA GmbH
 *  Airpark Business Center
 *  Airport Boulevard B210
 *  77836 Rheinmnster
 *  Germany
 *  Tel: +49(0)7229/1847-0    |  Fax: +49(0)7229/1847-200
 *  http://www.addi-data-com  |  info@addi-data.com
 *  @endverbatim
 **/

using System;
using System.Collections.Generic;
using System.Text;

namespace PCI3300_NET
{
    /// <summary>
    /// Stores the data related to a EndOfSequence event.
    /// The end of sequence event is raised when a conversion sequence ends.
    /// </summary>
    public class EndOfSequenceEventArgs
    {
        /// <summary>
        /// True if the FIFO buffer has overflowed
        /// </summary>
        public Boolean fifoOverflow;
        /// <summary>
        /// The mask containing information about the device that generated the interruption
        /// </summary>
        public UInt32 interruptMask;
        /// <summary>
        /// The data size
        /// </summary>
        public UInt32 size;
        /// <summary>
        /// An array containing the data related to the interruption
        /// </summary>
        public UInt32 [] args;

    }
}
