/** @file TimerEventArgs.cs
 *
 *  @authors S. Beuque
 *  @date    Creation: 06.10.2014
 *
 *  @par DESCRIPTION
 *  Timer event arguments definition 
 *
 *  @par LICENCE
 *  @verbatim
 *  Copyright (C) 2009 - 2014 ADDI-DATA GmbH
 *
 *  ADDI-DATA GmbH
 *  Airpark Business Center
 *  Airport Boulevard B210
 *  77836 Rheinmnster
 *  Germany
 *  Tel: +49(0)7229/1847-0    |  Fax: +49(0)7229/1847-200
 *  http://www.addi-data-com  |  info@addi-data.com
 *  @endverbatim
 **/

using System;
using System.Collections.Generic;
using System.Text;

namespace PCI3300_NET
{
    /// <summary>
    /// Stores the data related to a Timer event.
    /// The timer event is raised when the timer reaches 0.
    /// </summary>
    public class TimerEventArgs
    {
        /// <summary>
        /// True if the FIFO buffer has overflowed
        /// </summary>
        public Boolean fifoOverflow;
        /// <summary>
        /// The mask containing information about the device that generated the interruption
        /// </summary>
        public UInt32 interruptMask;

    }
}
