using System;
using System.Collections.Generic;
using System.Text;

namespace Scan
{
    /// <summary>
    /// Enables to compute an average on a value
    /// </summary>
    class FloatingAverage
    {
        /// <summary>
        /// Store the values
        /// </summary>
        private Queue<double> _values;

        /// <summary>
        /// The size of the queue
        /// </summary>
        private int _size;
        
        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="size"></param>
        public FloatingAverage(int size)
        {
            this._values = new Queue<double>(size);
            this._size = size;
        }

        /// <summary>
        /// Add a value and return the average
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public double Add(double value)
        {
            double average = 0;
            this._values.Enqueue(value);

            // Dequeue a value ?
            if (this._values.Count > this._size)
            {
                this._values.Dequeue();
            }

            // Compute the average
            foreach (double val in this._values)
            {
                average += val;
            }

            return (average / this._values.Count );
        }

    }
}
