using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace ReadDigitalInputs
{
    public partial class ReadDigitalInputs : Form
    {
        /// <summary>
        /// Handle to the first board
        /// </summary>
        PCI3300_NET.PCI3300 board;

        /// <summary>
        /// Usefull variable used to access the input status picture
        /// </summary>
        PictureBox[] inputStatusBox;

        /// <summary>
        /// Constructor of the form
        /// </summary>
        public ReadDigitalInputs()
        {
            InitializeComponent();
            inputStatusBox = new PictureBox[4];
            inputStatusBox[0] = input0StatusBox;
            inputStatusBox[1] = input1StatusBox;
            inputStatusBox[2] = input2StatusBox;
            inputStatusBox[3] = input3StatusBox;
        }

        /// <summary>
        /// Call at the first load
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ReadDigitalInputs_Load(object sender, EventArgs e)
        {
             // Open the first board of the system
            this.board = PCI3300_NET.PCI3300.OpenBoard(0);
            // Error handling
            if (this.board == null)
            {
                MessageBox.Show("Error OpenBoard returned null");
                this.Close();
                return;
            }
            // Start the timer
            this.readTimer.Start();
        }

        /// <summary>
        /// The read timer ticks
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void readTimer_Tick(object sender, EventArgs e)
        {
            int returnValue = 0;
            byte inputValue = 0;
            // We read the status of the outputs
            if ( ( returnValue = this.board.Read4DigitalInputs(out inputValue)) != 0)
            {
                MessageBox.Show("Error " + returnValue.ToString() + " in Read4DigitalInputs");
                this.Close();
                return;
            }

            // We change the image given the new status
            for (int i = 0; i < 4; i++)
            {
                if (((inputValue >> i) & 1) == 1)
                {
                    inputStatusBox[i].Image = global::ReadDigitalInputs.Properties.Resources.led_on;
                }
                else
                {
                    inputStatusBox[i].Image = global::ReadDigitalInputs.Properties.Resources.led_off;
                }
            }

            this.ResumeLayout(false);
            this.PerformLayout();
        }

        /// <summary>
        /// Occurs when the user closes the form
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ReadDigitalInputs_FormClosing(object sender, FormClosingEventArgs e)
        {
            // Stop the timer
            this.readTimer.Stop();
        }
    }
}